<!DOCTYPE html>
<html lang="en">
	<head>

		<!-- Meta Tags -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="description" content="Dreams POS is a powerful Bootstrap based Inventory Management Admin Template designed for businesses, offering seamless invoicing, project tracking, and estimates.">
		<meta name="keywords" content="inventory management, admin dashboard, bootstrap template, invoicing, estimates, business management, responsive admin, POS system">
		<meta name="author" content="Dreams Technologies">
		<meta name="robots" content="index, follow">
        <meta name="csrf-token" content="{{ csrf_token() }}">
		<title>Dreams POS - Inventory Management & Admin Dashboard Template</title>

		<script src="{{asset('assets/js/theme-script.js')}}"></script>

		<!-- Favicon -->
        <link rel="shortcut icon" type="image/x-icon" href="{{asset('assets/img/favicon.png')}}">

		<!-- Apple Touch Icon -->
		<link rel="apple-touch-icon" sizes="180x180" href="{{asset('assets/img/apple-touch-icon.png')}}">
		
		<!-- Bootstrap CSS -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

		<!-- Datetimepicker CSS -->
		<link rel="stylesheet" href="{{asset('assets/css/bootstrap-datetimepicker.min.css')}}">
		
		<!-- animation CSS -->
        <link rel="stylesheet" href="{{asset('assets/css/animate.css')}}">

		<!-- Select2 CSS -->
		<link rel="stylesheet" href="{{asset('assets/plugins/select2/css/select2.min.css')}}">

		<!-- Datatable CSS -->
		<link rel="stylesheet" href="{{asset('assets/css/dataTables.bootstrap5.min.css')}}">
		
        <!-- Fontawesome CSS -->
		<link rel="stylesheet" href="{{asset('assets/plugins/fontawesome/css/fontawesome.min.css')}}">
		<link rel="stylesheet" href="{{asset('assets/plugins/fontawesome/css/all.min.css')}}">

		<!-- Daterangepikcer CSS -->
		<link rel="stylesheet" href="{{asset('assets/plugins/daterangepicker/daterangepicker.css')}}">

		<!-- Tabler Icon CSS -->
		<link rel="stylesheet" href="{{asset('assets/plugins/tabler-icons/tabler-icons.min.css')}}">

		<!-- Owl Carousel CSS -->
		<link rel="stylesheet" href="{{asset('assets/plugins/owlcarousel/owl.carousel.min.css')}}">
		<link rel="stylesheet" href="{{asset('assets/plugins/owlcarousel/owl.theme.default.min.css')}}">
		
		<!-- Color Picker Css -->
	<link rel="stylesheet" href="{{asset('assets/plugins/@simonwep/pickr/themes/nano.min.css')}}">

	    <!-- Main CSS -->
        <link rel="stylesheet" href="{{asset('assets/css/style.css')}}">
		
	</head>
	
	<body class="pos-page">
		<div id="global-loader" >
			<div class="whirly-loader"> </div>
		</div>
		<!-- Main Wrapper -->
		<div class="main-wrapper">

			<!-- Header -->
			<div class="header pos-header">
			
				<!-- Logo -->
				 <div class="header-left active">
					<a href="index.html" class="logo logo-normal">
						<img src="{{asset('assets/img/logo.svg')}}"  alt="Img">
					</a>
					<a href="index.html" class="logo logo-white">
						<img src="{{asset('assets/img/logo-white.svg')}}"  alt="Img">
					</a>
					<a href="index.html" class="logo-small">
						<img src="{{asset('assets/img/logo-small.png')}}"  alt="Img">
					</a>
				</div>
				<!-- /Logo -->
				
				<a id="mobile_btn" class="mobile_btn d-none" href="#sidebar">
					<span class="bar-icon">
						<span></span>
						<span></span>
						<span></span>
					</span>
				</a>
				
				<!-- Header Menu -->
				<ul class="nav user-menu">

					<!-- Search -->
					<li class="nav-item time-nav">
						<span class="bg-teal text-white d-inline-flex align-items-center"><img src="{{asset('assets/img/icons/clock-icon.svg')}}" alt="img" class="me-2">09:25:32</span>
					</li>
					<!-- /Search -->
					
					<li class="nav-item pos-nav">
						<a href="index.html" class="btn btn-purple btn-md d-inline-flex align-items-center">
							<i class="ti ti-world me-1"></i>Dashboard
						</a>
					</li>

					<!-- Select Store -->
					<li class="nav-item dropdown has-arrow main-drop select-store-dropdown">
						<a href="javascript:void(0);" class="dropdown-toggle nav-link select-store"
							data-bs-toggle="dropdown">
							<span class="user-info">
								<span class="user-letter">
									<img src="{{asset('assets/img/store/store-01.png')}}" alt="Store Logo" class="img-fluid">
								</span>
								<span class="user-detail">
									<span class="user-name">Freshmart</span>
								</span>
							</span>
						</a>
						<div class="dropdown-menu dropdown-menu-right">
							<a href="javascript:void(0);" class="dropdown-item">
								<img src="{{asset('assets/img/store/store-01.png')}}" alt="Store Logo" class="img-fluid">Freshmart
							</a>
							<a href="javascript:void(0);" class="dropdown-item">
								<img src="{{asset('assets/img/store/store-02.png')}}" alt="Store Logo" class="img-fluid">Grocery Apex
							</a>
							<a href="javascript:void(0);" class="dropdown-item">
								<img src="{{asset('assets/img/store/store-03.png')}}" alt="Store Logo" class="img-fluid">Grocery Bevy
							</a>
							<a href="javascript:void(0);" class="dropdown-item">
								<img src="{{asset('assets/img/store/store-04.png')}}" alt="Store Logo" class="img-fluid">Grocery Eden
							</a>
						</div>
					</li>
					<!-- /Select Store -->
					
					<li class="nav-item nav-item-box">
						<a href="#" data-bs-toggle="modal" data-bs-target="#calculator" class="bg-orange border-orange text-white"><i class="ti ti-calculator"></i></a>
					</li>
					<li class="nav-item nav-item-box">
						<a href="javascript:void(0);" id="btnFullscreen" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Maximize" >
							<i class="ti ti-maximize"></i>
						</a>
					</li>
					<li class="nav-item nav-item-box" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Cash Register">
						<a href="#" data-bs-toggle="modal" data-bs-target="#cash-register"><i class="ti ti-cash"></i></a>
					</li>
					<li class="nav-item nav-item-box" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Print Last Reciept">
						<a href="#"><i class="ti ti-printer"></i></a>
					</li>
					<li class="nav-item nav-item-box" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Today’s Sale">
						<a href="#" data-bs-toggle="modal" data-bs-target="#today-sale"><i class="ti ti-progress"></i></a>
					</li>
					<li class="nav-item nav-item-box" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Today’s Profit">
						<a href="#" data-bs-toggle="modal" data-bs-target="#today-profit"><i class="ti ti-chart-infographic"></i></a>
					</li>
					<li class="nav-item nav-item-box" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="POS Settings">
						<a href="pos-settings.html"><i class="ti ti-settings"></i></a>
					</li>
					<li class="nav-item dropdown has-arrow main-drop profile-nav">
						<a href="javascript:void(0);" class="nav-link userset" data-bs-toggle="dropdown">
							<span class="user-info p-0">
								<span class="user-letter">
									<img src="{{asset('assets/img/profiles/avator1.jpg')}}" alt="Img" class="img-fluid">
								</span>
							</span>
						</a>
						<div class="dropdown-menu menu-drop-user">
							<div class="profilename">
								<div class="profileset">
									<span class="user-img"><img src="{{asset('assets/img/profiles/avator1.jpg')}}" alt="Img">
										<span class="status online"></span></span>
									<div class="profilesets">
										<h6>John Smilga</h6>
										<h5>Super Admin</h5>
									</div>
								</div>
								<hr class="m-0">
								<a class="dropdown-item" href="profile.html"><i class="me-2" data-feather="user"></i>My
									Profile</a>
								<a class="dropdown-item" href="general-settings.html"><i class="me-2" data-feather="settings"></i>Settings</a>
								<hr class="m-0">
								<a class="dropdown-item logout pb-0" href="signin.html"><img src="{{asset('assets/img/icons/log-out.svg')}}" class="me-2" alt="img">Logout</a>
							</div>
						</div>
					</li>
				</ul>
				<!-- /Header Menu -->
				
				<!-- Mobile Menu -->
				<div class="dropdown mobile-user-menu">
					<a href="javascript:void(0);" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-ellipsis-v"></i></a>
					<div class="dropdown-menu dropdown-menu-right">
						<a class="dropdown-item" href="profile.html">My Profile</a>
						<a class="dropdown-item" href="general-settings.html">Settings</a>
						<a class="dropdown-item" href="signin.html">Logout</a>
					</div>
				</div>
				<!-- /Mobile Menu -->
			</div>
			<!-- /Header -->

			<!-- Sidebar -->
			<div class="sidebar d-none" id="sidebar">
				<!-- Logo -->
				<div class="sidebar-logo">
					<a href="index.html" class="logo logo-normal">
						<img src="{{asset('assets/img/logo.svg')}}" alt="Img">
					</a>
					<a href="index.html" class="logo logo-white">
						<img src="{{asset('assets/img/logo-white.svg')}}" alt="Img">
					</a>
					<a href="index.html" class="logo-small">
						<img src="{{asset('assets/img/logo-small.png')}}" alt="Img">
					</a>
					<a id="toggle_btn" href="javascript:void(0);">
						<i data-feather="chevrons-left" class="feather-16"></i>
					</a>
				</div>
				<!-- /Logo -->
				<div class="modern-profile p-3 pb-0">
					<div class="text-center rounded bg-light p-3 mb-4 user-profile">
						<div class="avatar avatar-lg online mb-3">
							<img src="{{asset('assets/img/customer/customer15.jpg')}}" alt="Img" class="img-fluid rounded-circle">
						</div>
						<h6 class="fs-14 fw-bold mb-1">Adrian Herman</h6>
						<p class="fs-12 mb-0">System Admin</p>
					</div>
					<div class="sidebar-nav mb-3">
						<ul class="nav nav-tabs nav-tabs-solid nav-tabs-rounded nav-justified bg-transparent" role="tablist">
							<li class="nav-item"><a class="nav-link active border-0" href="#">Menu</a></li>
							<li class="nav-item"><a class="nav-link border-0" href="chat.html">Chats</a></li>
							<li class="nav-item"><a class="nav-link border-0" href="email.html">Inbox</a></li>
						</ul>
					</div>
				</div>
				<div class="sidebar-header p-3 pb-0 pt-2">
					<div class="text-center rounded bg-light p-2 mb-4 sidebar-profile d-flex align-items-center">
						<div class="avatar avatar-md onlin">
							<img src="{{asset('assets/img/customer/customer15.jpg')}}" alt="Img" class="img-fluid rounded-circle">
						</div>
						<div class="text-start sidebar-profile-info ms-2">
							<h6 class="fs-14 fw-bold mb-1">Adrian Herman</h6>
							<p class="fs-12">System Admin</p>
						</div>
					</div>
					<div class="d-flex align-items-center justify-content-between menu-item mb-3">
						<div>
							<a href="index.html" class="btn btn-sm btn-icon bg-light">
								<i class="ti ti-layout-grid-remove"></i>
							</a>
						</div>
						<div>
							<a href="chat.html" class="btn btn-sm btn-icon bg-light">
								<i class="ti ti-brand-hipchat"></i>
							</a>
						</div>
						<div>
							<a href="email.html" class="btn btn-sm btn-icon bg-light position-relative">
								<i class="ti ti-message"></i>
							</a>
						</div>
						<div class="notification-item">
							<a href="activities.html" class="btn btn-sm btn-icon bg-light position-relative">
								<i class="ti ti-bell"></i>
								<span class="notification-status-dot"></span>
							</a>
						</div>
						<div class="me-0">
							<a href="general-settings.html" class="btn btn-sm btn-icon bg-light">
								<i class="ti ti-settings"></i>
							</a>
						</div>
					</div>
				</div>
				<div class="sidebar-inner slimscroll">
					<div id="sidebar-menu" class="sidebar-menu">
						<ul>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Main</h6>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);" class="subdrop active"><i class="ti ti-layout-grid fs-16 me-2"></i><span>Dashboard</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="index.html" class="active">Admin Dashboard</a></li>
											<li><a href="admin-dashboard.html">Admin Dashboard 2</a></li>
											<li><a href="sales-dashboard.html">Sales Dashboard</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-user-edit fs-16 me-2"></i><span>Super Admin</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="dashboard.html">Dashboard</a></li>
											<li><a href="companies.html">Companies</a></li>
											<li><a href="subscription.html">Subscriptions</a></li>
											<li><a href="packages.html">Packages</a></li>
											<li><a href="domain.html">Domain</a></li>
											<li><a href="purchase-transaction.html">Purchase Transaction</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-brand-apple-arcade fs-16 me-2"></i><span>Application</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="chat.html">Chat</a></li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Call<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="video-call.html">Video Call</a></li>
													<li><a href="audio-call.html">Audio Call</a></li>
													<li><a href="call-history.html">Call History</a></li>
												</ul>
											</li>
											<li><a href="calendar.html">Calendar</a></li>
											<li><a href="contacts.html">Contacts</a></li>
											<li><a href="email.html">Email</a></li>
											<li><a href="todo.html">To Do</a></li>
											<li><a href="notes.html">Notes</a></li>
											<li><a href="file-manager.html">File Manager</a></li>
											<li><a href="projects.html">Projects</a></li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Ecommerce<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="products.html">Products</a></li>
													<li><a href="orders.html">Orders</a></li>
													<li><a href="customers.html">Customers</a></li>
													<li><a href="cart.html">Cart</a></li>
													<li><a href="checkout.html">Checkout</a></li>
													<li><a href="wishlist.html">Wishlist</a></li>
													<li><a href="reviews.html">Reviews</a></li>
												</ul>
											</li>
											<li><a href="social-feed.html">Social Feed</a></li>
											<li><a href="search-list.html">Search List</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-layout-sidebar-right-collapse fs-16 me-2"></i><span>Layouts</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="layout-horizontal.html">Horizontal</a></li>
											<li><a href="layout-detached.html">Detached</a></li>
											<li><a href="layout-two-column.html">Two Column</a></li>
											<li><a href="layout-hovered.html">Hovered</a></li>
											<li><a href="layout-boxed.html">Boxed</a></li>
											<li><a href="layout-rtl.html">RTL</a></li>
											<li><a href="layout-dark.html">Dark</a></li>
										</ul>
									</li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Inventory</h6>
								<ul>
									<li><a href="product-list.html"><i data-feather="box"></i><span>Products</span></a></li>
									<li><a href="add-product.html"><i class="ti ti-table-plus fs-16 me-2"></i><span>Create Product</span></a></li>
									<li><a href="expired-products.html"><i class="ti ti-progress-alert fs-16 me-2"></i><span>Expired Products</span></a></li>
									<li><a href="low-stocks.html"><i class="ti ti-trending-up-2 fs-16 me-2"></i><span>Low Stocks</span></a></li>
									<li><a href="category-list.html"><i class="ti ti-list-details fs-16 me-2"></i><span>Category</span></a></li>
									<li><a href="sub-categories.html"><i class="ti ti-carousel-vertical fs-16 me-2"></i><span>Sub Category</span></a></li>
									<li><a href="brand-list.html"><i class="ti ti-triangles fs-16 me-2"></i><span>Brands</span></a></li>
									<li><a href="units.html"><i class="ti ti-brand-unity fs-16 me-2"></i><span>Units</span></a></li>
									<li><a href="varriant-attributes.html"><i class="ti ti-checklist fs-16 me-2"></i><span>Variant Attributes</span></a></li>
									<li><a href="warranty.html"><i class="ti ti-certificate fs-16 me-2"></i><span>Warranties</span></a></li>
									<li><a href="barcode.html"><i class="ti ti-barcode fs-16 me-2"></i><span>Print Barcode</span></a></li>
									<li><a href="qrcode.html"><i class="ti ti-qrcode fs-16 me-2"></i><span>Print QR Code</span></a></li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Stock</h6>
								<ul>
									<li><a href="manage-stocks.html"><i class="ti ti-stack-3 fs-16 me-2"></i><span>Manage Stock</span></a></li>
									<li><a href="stock-adjustment.html"><i class="ti ti-stairs-up fs-16 me-2"></i><span>Stock Adjustment</span></a></li>
									<li><a href="stock-transfer.html"><i class="ti ti-stack-pop fs-16 me-2"></i><span>Stock Transfer</span></a></li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Sales</h6>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-layout-grid fs-16 me-2"></i><span>Sales</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="online-orders.html">Online Orders</a></li>
											<li><a href="pos-orders.html">POS Orders</a></li>
										</ul>
									</li>
									<li><a href="invoice.html"><i class="ti ti-file-invoice fs-16 me-2"></i><span>Invoices</span></a></li>
									<li><a href="sales-returns.html"><i class="ti ti-receipt-refund fs-16 me-2"></i><span>Sales Return</span></a></li>
									<li><a href="quotation-list.html"><i class="ti ti-files fs-16 me-2"></i><span>Quotation</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-device-laptop fs-16 me-2"></i><span>POS</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="pos.html">POS 1</a></li>
											<li><a href="pos-2.html">POS 2</a></li>
											<li><a href="pos-3.html">POS 3</a></li>
											<li><a href="pos-4.html">POS 4</a></li>
											<li><a href="pos-5.html">POS 5</a></li>
										</ul>
									</li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Promo</h6>
								<ul>
									<li><a href="coupons.html"><i class="ti ti-ticket fs-16 me-2"></i><span>Coupons</span></a></li>
									<li><a href="gift-cards.html"><i class="ti ti-cards fs-16 me-2"></i><span>Gift Cards</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-file-percent fs-16 me-2"></i><span>Discount</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="discount-plan.html">Discount Plan</a></li>
											<li><a href="discount.html">Discount</a></li>
										</ul>
									</li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Purchases</h6>
								<ul>
									<li><a href="purchase-list.html"><i class="ti ti-shopping-bag fs-16 me-2"></i><span>Purchases</span></a></li>
									<li><a href="purchase-order-report.html"><i class="ti ti-file-unknown fs-16 me-2"></i><span>Purchase Order</span></a></li>
									<li><a href="purchase-returns.html"><i class="ti ti-file-upload fs-16 me-2"></i><span>Purchase Return</span></a></li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Finance & Accounts</h6>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-file-stack fs-16 me-2"></i><span>Expenses</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="expense-list.html">Expenses</a></li>
											<li><a href="expense-category.html">Expense Category</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-file-pencil fs-16 me-2"></i><span>Income</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="income.html">Income</a></li>
											<li><a href="income-category.html">Income Category</a></li>
										</ul>
									</li>
									<li><a href="account-list.html"><i class="ti ti-building-bank fs-16 me-2"></i><span>Bank Accounts</span></a></li>
									<li><a href="money-transfer.html"><i class="ti ti-moneybag fs-16 me-2"></i><span>Money Transfer</span></a></li>
									<li><a href="balance-sheet.html"><i class="ti ti-report-money fs-16 me-2"></i><span>Balance Sheet</span></a></li>
									<li><a href="trial-balance.html"><i class="ti ti-alert-circle fs-16 me-2"></i><span>Trial Balance</span></a></li>
									<li><a href="cash-flow.html"><i class="ti ti-zoom-money fs-16 me-2"></i><span>Cash Flow</span></a></li>
									<li><a href="account-statement.html"><i class="ti ti-file-infinity fs-16 me-2"></i><span>Account Statement</span></a></li>

								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Peoples</h6>
								<ul>
									<li><a href="customers.html"><i class="ti ti-users-group fs-16 me-2"></i><span>Customers</span></a></li>
									<li><a href="billers.html"><i class="ti ti-user-up fs-16 me-2"></i><span>Billers</span></a></li>
									<li><a href="suppliers.html"><i class="ti ti-user-dollar fs-16 me-2"></i><span>Suppliers</span></a></li>
									<li><a href="store-list.html"><i class="ti ti-home-bolt fs-16 me-2"></i><span>Stores</span></a></li>
									<li><a href="warehouse.html"><i class="ti ti-archive fs-16 me-2"></i><span>Warehouses</span></a>
									</li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">HRM</h6>
								<ul>
									<li><a href="employees-grid.html"><i class="ti ti-user fs-16 me-2"></i><span>Employees</span></a></li>
									<li><a href="department-grid.html"><i class="ti ti-compass fs-16 me-2"></i><span>Departments</span></a></li>
									<li><a href="designation.html"><i class="ti ti-git-merge fs-16 me-2"></i><span>Designation</span></a></li>
									<li><a href="shift.html"><i class="ti ti-arrows-shuffle fs-16 me-2"></i><span>Shifts</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-user-cog fs-16 me-2"></i><span>Attendence</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="attendance-employee.html">Employee</a></li>
											<li><a href="attendance-admin.html">Admin</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-calendar fs-16 me-2"></i><span>Leaves</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="leaves-admin.html">Admin Leaves</a></li>
											<li><a href="leaves-employee.html">Employee Leaves</a></li>
											<li><a href="leave-types.html">Leave Types</a></li>
										</ul>
									</li>
									<li><a href="holidays.html"><i class="ti ti-calendar-share fs-16 me-2"></i><span>Holidays</span></a>
									</li>
									<li class="submenu">
										<a href="employee-salary.html"><i class="ti ti-file-dollar fs-16 me-2"></i><span>Payroll</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="employee-salary.html">Employee Salary</a></li>
											<li><a href="payslip.html">Payslip</a></li>
										</ul>
									</li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Reports</h6>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-chart-bar fs-16 me-2"></i><span>Sales Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="sales-report.html">Sales Report</a></li>
											<li><a href="best-seller.html">Best Seller</a></li>
										</ul>
									</li>
									<li><a href="purchase-report.html"><i class="ti ti-chart-pie-2 fs-16 me-2"></i><span>Purchase report</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-triangle-inverted fs-16 me-2"></i><span>Inventory Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="inventory-report.html">Inventory Report</a></li>
											<li><a href="stock-history.html">Stock History</a></li>
											<li><a href="sold-stock.html">Sold Stock</a></li>
										</ul>
									</li>
									<li><a href="invoice-report.html"><i class="ti ti-businessplan fs-16 me-2"></i><span>Invoice Report</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-user-star fs-16 me-2"></i><span>Supplier Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="supplier-report.html">Supplier Report</a></li>
											<li><a href="supplier-due-report.html">Supplier Due Report</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-report fs-16 me-2"></i><span>Customer Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="customer-report.html">Customer Report</a></li>
											<li><a href="customer-due-report.html">Customer Due Report</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-report-analytics fs-16 me-2"></i><span>Product Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="product-report.html">Product Report</a></li>
											<li><a href="product-expiry-report.html">Product Expiry Report</a></li>
											<li><a href="product-quantity-alert.html">Product Quantity Alert</a></li>
										</ul>
									</li>
									<li><a href="expense-report.html"><i class="ti ti-file-vector fs-16 me-2"></i><span>Expense Report</span></a></li>
									<li><a href="income-report.html"><i class="ti ti-chart-ppf fs-16 me-2"></i><span>Income Report</span></a></li>
									<li><a href="tax-reports.html"><i class="ti ti-chart-dots-2 fs-16 me-2"></i><span>Tax Report</span></a></li>
									<li><a href="profit-and-loss.html"><i class="ti ti-chart-donut fs-16 me-2"></i><span>Profit & Loss</span></a></li>
									<li><a href="annual-report.html"><i class="ti ti-report-search fs-16 me-2"></i><span>Annual Report</span></a></li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Content (CMS)</h6>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-page-break fs-16 me-2"></i><span>Pages</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="pages.html">Pages</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-wallpaper fs-16 me-2"></i><span>Blog</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="all-blog.html">All Blog</a></li>
											<li><a href="blog-tag.html">Blog Tags</a></li>
											<li><a href="blog-categories.html">Categories</a></li>
											<li><a href="blog-comments.html">Blog Comments</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-map-pin fs-16 me-2"></i><span>Location</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="countries.html">Countries</a></li>
											<li><a href="states.html">States</a></li>
											<li><a href="cities.html">Cities</a></li>
										</ul>
									</li>
									<li><a href="testimonials.html"><i class="ti ti-star fs-16 me-2"></i><span>Testimonials</span></a></li>
									<li><a href="faq.html"><i class="ti ti-help-circle fs-16 me-2"></i><span>FAQ</span></a></li>

								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">User Management</h6>
								<ul>
									<li><a href="users.html"><i class="ti ti-shield-up fs-16 me-2"></i><span>Users</span></a></li>
									<li><a href="roles-permissions.html"><i class="ti ti-jump-rope fs-16 me-2"></i><span>Roles & Permissions</span></a></li>
									<li><a href="delete-account.html"><i class="ti ti-trash-x fs-16 me-2"></i><span>Delete Account Request</span></a></li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Pages</h6>
								<ul>
									<li><a href="profile.html"><i class="ti ti-user-circle fs-16 me-2"></i><span>Profile</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-shield fs-16 me-2"></i><span>Authentication</span><span class="menu-arrow"></span></a>
										<ul>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Login<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="signin.html">Cover</a></li>
													<li><a href="signin-2.html">Illustration</a></li>
													<li><a href="signin-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Register<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="register.html">Cover</a></li>
													<li><a href="register-2.html">Illustration</a></li>
													<li><a href="register-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Forgot Password<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="forgot-password.html">Cover</a></li>
													<li><a href="forgot-password-2.html">Illustration</a></li>
													<li><a href="forgot-password-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Reset Password<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="reset-password.html">Cover</a></li>
													<li><a href="reset-password-2.html">Illustration</a></li>
													<li><a href="reset-password-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Email Verification<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="email-verification.html">Cover</a></li>
													<li><a href="email-verification-2.html">Illustration</a></li>
													<li><a href="email-verification-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">2 Step Verification<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="two-step-verification.html">Cover</a></li>
													<li><a href="two-step-verification-2.html">Illustration</a></li>
													<li><a href="two-step-verification-3.html">Basic</a></li>
												</ul>
											</li>
											<li><a href="lock-screen.html">Lock Screen</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-file-x fs-16 me-2"></i><span>Error Pages</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="error-404.html">404 Error </a></li>
											<li><a href="error-500.html">500 Error </a></li>
										</ul>
									</li>
									<li>
										<a href="blank-page.html"><i class="ti ti-file fs-16 me-2"></i><span>Blank Page</span> </a>
									</li>
									<li>
										<a href="pricing.html"><i class="ti ti-currency-dollar fs-16 me-2"></i><span>Pricing</span> </a>
									</li>
									<li>
										<a href="coming-soon.html"><i class="ti ti-send fs-16 me-2"></i><span>Coming Soon</span> </a>
									</li>
									<li>
										<a href="under-maintenance.html"><i class="ti ti-alert-triangle fs-16 me-2"></i><span>Under Maintenance</span> </a>
									</li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Settings</h6>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-settings fs-16 me-2"></i><span>General Settings</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="general-settings.html">Profile</a></li>
											<li><a href="security-settings.html">Security</a></li>
											<li><a href="notification.html">Notifications</a></li>
											<li><a href="connected-apps.html">Connected Apps</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-world fs-16 me-2"></i><span>Website Settings</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="system-settings.html">System Settings</a></li>
											<li><a href="company-settings.html">Company Settings </a></li>
											<li><a href="localization-settings.html">Localization</a></li>
											<li><a href="prefixes.html">Prefixes</a></li>
											<li><a href="preference.html">Preference</a></li>
											<li><a href="appearance.html">Appearance</a></li>
											<li><a href="social-authentication.html">Social Authentication</a></li>
											<li><a href="language-settings.html">Language</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-device-mobile fs-16 me-2"></i>
											<span>App Settings</span><span class="menu-arrow"></span>
										</a>
										<ul>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Invoice<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="invoice-settings.html">Invoice Settings</a></li>
													<li><a href="invoice-template.html">Invoice Template</a></li>
												</ul>
											</li>
											<li><a href="printer-settings.html">Printer</a></li>
											<li><a href="pos-settings.html">POS</a></li>
											<li><a href="custom-fields.html">Custom Fields</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-device-desktop fs-16 me-2"></i>
											<span>System Settings</span><span class="menu-arrow"></span>
										</a>
										<ul>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Email<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="email-settings.html">Email Settings</a></li>
													<li><a href="email-template.html">Email Template</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">SMS<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="sms-settings.html">SMS Settings</a></li>
													<li><a href="sms-template.html">SMS Template</a></li>
												</ul>
											</li>
											<li><a href="otp-settings.html">OTP</a></li>
											<li><a href="gdpr-settings.html">GDPR Cookies</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-settings-dollar fs-16 me-2"></i>
											<span>Financial Settings</span><span class="menu-arrow"></span>
										</a>
										<ul>
											<li><a href="payment-gateway-settings.html">Payment Gateway</a></li>
											<li><a href="bank-settings-grid.html">Bank Accounts</a></li>
											<li><a href="tax-rates.html">Tax Rates</a></li>
											<li><a href="currency-settings.html">Currencies</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-settings-2 fs-16 me-2"></i>
											<span>Other Settings</span><span class="menu-arrow"></span>
										</a>
										<ul>
											<li><a href="storage-settings.html">Storage</a></li>
											<li><a href="ban-ip-address.html">Ban IP Address</a></li>
										</ul>
									</li>
									<li>
										<a href="signin.html"><i class="ti ti-logout fs-16 me-2"></i><span>Logout</span> </a>
									</li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">UI Interface</h6>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);">
											<i class="ti ti-vector-bezier fs-16 me-2"></i><span>Base UI</span><span class="menu-arrow"></span>
										</a>
										<ul>
											<li><a href="ui-alerts.html">Alerts</a></li>
											<li><a href="ui-accordion.html">Accordion</a></li>
											<li><a href="ui-avatar.html">Avatar</a></li>
											<li><a href="ui-badges.html">Badges</a></li>
											<li><a href="ui-borders.html">Border</a></li>
											<li><a href="ui-buttons.html">Buttons</a></li>
											<li><a href="ui-buttons-group.html">Button Group</a></li>
											<li><a href="ui-breadcrumb.html">Breadcrumb</a></li>
											<li><a href="ui-cards.html">Card</a></li>
											<li><a href="ui-carousel.html">Carousel</a></li>
											<li><a href="ui-colors.html">Colors</a></li>
											<li><a href="ui-dropdowns.html">Dropdowns</a></li>
											<li><a href="ui-grid.html">Grid</a></li>
											<li><a href="ui-images.html">Images</a></li>
											<li><a href="ui-lightbox.html">Lightbox</a></li>
											<li><a href="ui-media.html">Media</a></li>
											<li><a href="ui-modals.html">Modals</a></li>
											<li><a href="ui-offcanvas.html">Offcanvas</a></li>
											<li><a href="ui-pagination.html">Pagination</a></li>
											<li><a href="ui-popovers.html">Popovers</a></li>
											<li><a href="ui-progress.html">Progress</a></li>
											<li><a href="ui-placeholders.html">Placeholders</a></li>
											<li><a href="ui-rangeslider.html">Range Slider</a></li>
											<li><a href="ui-spinner.html">Spinner</a></li>
											<li><a href="ui-sweetalerts.html">Sweet Alerts</a></li>
											<li><a href="ui-nav-tabs.html">Tabs</a></li>
											<li><a href="ui-toasts.html">Toasts</a></li>
											<li><a href="ui-tooltips.html">Tooltips</a></li>
											<li><a href="ui-typography.html">Typography</a></li>
											<li><a href="ui-video.html">Video</a></li>
											<li><a href="ui-sortable.html">Sortable</a></li>
											<li><a href="ui-swiperjs.html">Swiperjs</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);">
											<i data-feather="layers"></i><span>Advanced UI</span><span class="menu-arrow"></span>
										</a>
										<ul>
											<li><a href="ui-ribbon.html">Ribbon</a></li>
											<li><a href="ui-clipboard.html">Clipboard</a></li>
											<li><a href="ui-drag-drop.html">Drag & Drop</a></li>
											<li><a href="ui-rangeslider.html">Range Slider</a></li>
											<li><a href="ui-rating.html">Rating</a></li>
											<li><a href="ui-text-editor.html">Text Editor</a></li>
											<li><a href="ui-counter.html">Counter</a></li>
											<li><a href="ui-scrollbar.html">Scrollbar</a></li>
											<li><a href="ui-stickynote.html">Sticky Note</a></li>
											<li><a href="ui-timeline.html">Timeline</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-chart-infographic fs-16 me-2"></i>
											<span>Charts</span><span class="menu-arrow"></span>
										</a>
										<ul>
											<li><a href="chart-apex.html">Apex Charts</a></li>
											<li><a href="chart-c3.html">Chart C3</a></li>
											<li><a href="chart-js.html">Chart Js</a></li>
											<li><a href="chart-morris.html">Morris Charts</a></li>
											<li><a href="chart-flot.html">Flot Charts</a></li>
											<li><a href="chart-peity.html">Peity Charts</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-icons fs-16 me-2"></i>
											<span>Icons</span><span class="menu-arrow"></span>
										</a>
										<ul>
											<li><a href="icon-fontawesome.html">Fontawesome Icons</a></li>
											<li><a href="icon-feather.html">Feather Icons</a></li>
											<li><a href="icon-ionic.html">Ionic Icons</a></li>
											<li><a href="icon-material.html">Material Icons</a></li>
											<li><a href="icon-pe7.html">Pe7 Icons</a></li>
											<li><a href="icon-simpleline.html">Simpleline Icons</a></li>
											<li><a href="icon-themify.html">Themify Icons</a></li>
											<li><a href="icon-weather.html">Weather Icons</a></li>
											<li><a href="icon-typicon.html">Typicon Icons</a></li>
											<li><a href="icon-flag.html">Flag Icons</a></li>
											<li><a href="icon-tabler.html">Tabler Icons</a></li>
											<li><a href="icon-bootstrap.html">Bootstrap Icons</a></li>
											<li><a href="icon-remix.html">Remix Icons</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);">
											<i class="ti ti-input-search fs-16 me-2"></i><span>Forms</span><span class="menu-arrow"></span>
										</a>
										<ul>
											<li class="submenu submenu-two">
												<a href="javascript:void(0);">Form Elements<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="form-basic-inputs.html">Basic Inputs</a></li>
													<li><a href="form-checkbox-radios.html">Checkbox & Radios</a></li>
													<li><a href="form-input-groups.html">Input Groups</a></li>
													<li><a href="form-grid-gutters.html">Grid & Gutters</a></li>
													<li><a href="form-select.html">Form Select</a></li>
													<li><a href="form-mask.html">Input Masks</a></li>
													<li><a href="form-fileupload.html">File Uploads</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two">
												<a href="javascript:void(0);">Layouts<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="form-horizontal.html">Horizontal Form</a></li>
													<li><a href="form-vertical.html">Vertical Form</a></li>
													<li><a href="form-floating-labels.html">Floating Labels</a></li>
												</ul>
											</li>
											<li><a href="form-validation.html">Form Validation</a></li>
											<li><a href="form-select2.html">Select2</a></li>
											<li><a href="form-wizard.html">Form Wizard</a></li>
											<li><a href="form-pickers.html">Form Picker</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-table fs-16 me-2"></i><span>Tables</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="tables-basic.html">Basic Tables </a></li>
											<li><a href="data-tables.html">Data Table </a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-map-pin-pin fs-16 me-2"></i><span>Maps</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="maps-vector.html">Vector</a></li>
											<li><a href="maps-leaflet.html">Leaflet</a></li>
										</ul>
									</li>
								</ul>
							</li>
							<li class="submenu-open">
								<h6 class="submenu-hdr">Help</h6>
								<ul>
									<li><a href="javascript:void(0);"><i class="ti ti-file-text fs-16 me-2"></i><span>Documentation</span></a></li>
									<li><a href="javascript:void(0);"><i class="ti ti-exchange fs-16 me-2"></i><span>Changelog </span><span class="badge bg-primary badge-xs text-white fs-10 ms-2">v2.1.3</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><i class="ti ti-menu-2 fs-16 me-2"></i><span>Multi Level</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="javascript:void(0);">Level 1.1</a></li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Level 1.2<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="javascript:void(0);">Level 2.1</a></li>
													<li class="submenu submenu-two submenu-three"><a href="javascript:void(0);">Level 2.2<span class="menu-arrow inside-submenu inside-submenu-two"></span></a>
														<ul>
															<li><a href="javascript:void(0);">Level 3.1</a></li>
															<li><a href="javascript:void(0);">Level 3.2</a></li>
														</ul>
													</li>
												</ul>
											</li>
										</ul>
									</li>
								</ul>
							</li>
						</ul>
					</div>
				</div>
			</div>
			<!-- /Sidebar -->

			<!-- Horizontal Sidebar -->
			<div class="sidebar sidebar-horizontal d-none" id="horizontal-menu">
				<div id="sidebar-menu-3" class="sidebar-menu">
					<div class="main-menu">
						<ul class="nav-menu">
							<li class="submenu">
								<a href="index.html"><i class="ti ti-layout-grid fs-16 me-2"></i><span> Main Menu</span> <span class="menu-arrow"></span></a>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);" class="active subdrop"><span>Dashboard</span> <span class="menu-arrow"></span></a>
										<ul>
											<li><a href="index.html" class="active">Admin Dashboard</a></li>
											<li><a href="admin-dashboard.html">Admin Dashboard 2</a></li>
											<li><a href="sales-dashboard.html">Sales Dashboard</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Super Admin</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="dashboard.html">Dashboard</a></li>
											<li><a href="companies.html">Companies</a></li>
											<li><a href="subscription.html">Subscriptions</a></li>
											<li><a href="packages.html">Packages</a></li>
											<li><a href="domain.html">Domain</a></li>
											<li><a href="purchase-transaction.html">Purchase Transaction</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Application</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="chat.html">Chat</a></li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Call<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="video-call.html">Video Call</a></li>
													<li><a href="audio-call.html">Audio Call</a></li>
													<li><a href="call-history.html">Call History</a></li>
												</ul>
											</li>
											<li><a href="calendar.html">Calendar</a></li>
											<li><a href="contacts.html">Contacts</a></li>
											<li><a href="email.html">Email</a></li>
											<li><a href="todo.html">To Do</a></li>
											<li><a href="notes.html">Notes</a></li>
											<li><a href="file-manager.html">File Manager</a></li>
											<li><a href="projects.html">Projects</a></li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Ecommerce<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="products.html">Products</a></li>
													<li><a href="orders.html">Orders</a></li>
													<li><a href="customers.html">Customers</a></li>
													<li><a href="cart.html">Cart</a></li>
													<li><a href="checkout.html">Checkout</a></li>
													<li><a href="wishlist.html">Wishlist</a></li>
													<li><a href="reviews.html">Reviews</a></li>
												</ul>
											</li>
											<li><a href="social-feed.html">Social Feed</a></li>
											<li><a href="search-list.html">Search List</a></li>
										</ul>
									</li>
								</ul>
							</li>
							<li class="submenu">
								<a href="javascript:void(0);"><i class="ti ti-layout-sidebar-right-collapse fs-16 me-2"></i><span>Layouts</span><span class="menu-arrow"></span></a>
								<ul>
									<li><a href="layout-horizontal.html">Horizontal</a></li>
									<li><a href="layout-detached.html">Detached</a></li>
									<li><a href="layout-two-column.html">Two Column</a></li>
									<li><a href="layout-hovered.html">Hovered</a></li>
									<li><a href="layout-boxed.html">Boxed</a></li>
									<li><a href="layout-rtl.html">RTL</a></li>
									<li><a href="layout-dark.html">Dark</a></li>
								</ul>
							</li>
							<li class="submenu">
								<a href="javascript:void(0);"><i class="ti ti-brand-unity fs-16 me-2"></i><span> Inventory
									</span> <span class="menu-arrow"></span></a>
								<ul>
									<li><a href="product-list.html"><span>Products</span></a></li>
									<li><a href="add-product.html"><span>Create Product</span></a></li>
									<li><a href="expired-products.html"><span>Expired Products</span></a></li>
									<li><a href="low-stocks.html"><span>Low Stocks</span></a></li>
									<li><a href="category-list.html"><span>Category</span></a></li>
									<li><a href="sub-categories.html"><span>Sub Category</span></a></li>
									<li><a href="brand-list.html"><span>Brands</span></a></li>
									<li><a href="units.html"><span>Units</span></a></li>
									<li><a href="varriant-attributes.html"><span>Variant Attributes</span></a></li>
									<li><a href="warranty.html"><span>Warranties</span></a></li>
									<li><a href="barcode.html"><span>Print Barcode</span></a></li>
									<li><a href="qrcode.html"><span>Print QR Code</span></a></li>
								</ul>
							</li>
							<li class="submenu">
								<a href="javascript:void(0);"><i class="ti ti-layout-grid fs-16 me-2"></i><span>Sales &amp; Purchase</span> <span class="menu-arrow"></span></a>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Stock</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="manage-stocks.html"><span>Manage Stock</span></a></li>
											<li><a href="stock-adjustment.html"><span>Stock Adjustment</span></a></li>
											<li><a href="stock-transfer.html"><span>Stock Transfer</span></a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Sales</span><span class="menu-arrow"></span></a>
										<ul>
											<li class="submenu">
												<a href="javascript:void(0);"><span>Sales</span><span class="menu-arrow"></span></a>
												<ul>
													<li><a href="online-orders.html">Online Orders</a></li>
													<li><a href="pos-orders.html">POS Orders</a></li>
												</ul>
											</li>
											<li><a href="invoice.html"><span>Invoices</span></a></li>
											<li><a href="sales-returns.html"><span>Sales Return</span></a></li>
											<li><a href="quotation-list.html"><span>Quotation</span></a></li>
											<li class="submenu">
												<a href="javascript:void(0);"><span>POS</span><span class="menu-arrow"></span></a>
												<ul>
													<li><a href="pos.html">POS 1</a></li>
													<li><a href="pos-2.html">POS 2</a></li>
													<li><a href="pos-3.html">POS 3</a></li>
													<li><a href="pos-4.html">POS 4</a></li>
													<li><a href="pos-5.html">POS 5</a></li>
												</ul>
											</li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Promo</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="coupons.html"><span>Coupons</span></a></li>
											<li><a href="gift-cards.html"><span>Gift Cards</span></a></li>
											<li class="submenu">
												<a href="javascript:void(0);"><span>Discount</span><span class="menu-arrow"></span></a>
												<ul>
													<li><a href="discount-plan.html">Discount Plan</a></li>
													<li><a href="discount.html">Discount</a></li>
												</ul>
											</li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Purchase</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="purchase-list.html"><span>Purchases</span></a></li>
											<li><a href="purchase-order-report.html"><span>Purchase Order</span></a></li>
											<li><a href="purchase-returns.html"><span>Purchase Return</span></a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Expenses</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="expense-list.html">Expenses</a></li>
											<li><a href="expense-category.html">Expense Category</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Income</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="income.html">Income</a></li>
											<li><a href="income-category.html">Income Category</a></li>
										</ul>
									</li>
									<li><a href="account-list.html"><span>Bank Accounts</span></a></li>
									<li><a href="money-transfer.html"><span>Money Transfer</span></a></li>
									<li><a href="balance-sheet.html"><span>Balance Sheet</span></a></li>
									<li><a href="trial-balance.html"><span>Trial Balance</span></a></li>
									<li><a href="cash-flow.html"><span>Cash Flow</span></a></li>
									<li><a href="account-statement.html"><span>Account Statement</span></a></li>
								</ul>
							</li>
							<li class="submenu">
								<a href="javascript:void(0);"><i class="ti ti-users-group fs-16 me-2"></i><span>UI Interface</span> <span class="menu-arrow"></span></a>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Base UI</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="ui-alerts.html">Alerts</a></li>
											<li><a href="ui-accordion.html">Accordion</a></li>
											<li><a href="ui-avatar.html">Avatar</a></li>
											<li><a href="ui-badges.html">Badges</a></li>
											<li><a href="ui-borders.html">Border</a></li>
											<li><a href="ui-buttons.html">Buttons</a></li>
											<li><a href="ui-buttons-group.html">Button Group</a></li>
											<li><a href="ui-breadcrumb.html">Breadcrumb</a></li>
											<li><a href="ui-cards.html">Card</a></li>
											<li><a href="ui-carousel.html">Carousel</a></li>
											<li><a href="ui-colors.html">Colors</a></li>
											<li><a href="ui-dropdowns.html">Dropdowns</a></li>
											<li><a href="ui-grid.html">Grid</a></li>
											<li><a href="ui-images.html">Images</a></li>
											<li><a href="ui-lightbox.html">Lightbox</a></li>
											<li><a href="ui-media.html">Media</a></li>
											<li><a href="ui-modals.html">Modals</a></li>
											<li><a href="ui-offcanvas.html">Offcanvas</a></li>
											<li><a href="ui-pagination.html">Pagination</a></li>
											<li><a href="ui-popovers.html">Popovers</a></li>
											<li><a href="ui-progress.html">Progress</a></li>
											<li><a href="ui-placeholders.html">Placeholders</a></li>
											<li><a href="ui-rangeslider.html">Range Slider</a></li>
											<li><a href="ui-spinner.html">Spinner</a></li>
											<li><a href="ui-sweetalerts.html">Sweet Alerts</a></li>
											<li><a href="ui-nav-tabs.html">Tabs</a></li>
											<li><a href="ui-toasts.html">Toasts</a></li>
											<li><a href="ui-tooltips.html">Tooltips</a></li>
											<li><a href="ui-typography.html">Typography</a></li>
											<li><a href="ui-video.html">Video</a></li>
											<li><a href="ui-sortable.html">Sortable</a></li>
											<li><a href="ui-swiperjs.html">Swiperjs</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Advanced UI</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="ui-ribbon.html">Ribbon</a></li>
											<li><a href="ui-clipboard.html">Clipboard</a></li>
											<li><a href="ui-drag-drop.html">Drag & Drop</a></li>
											<li><a href="ui-rangeslider.html">Range Slider</a></li>
											<li><a href="ui-rating.html">Rating</a></li>
											<li><a href="ui-text-editor.html">Text Editor</a></li>
											<li><a href="ui-counter.html">Counter</a></li>
											<li><a href="ui-scrollbar.html">Scrollbar</a></li>
											<li><a href="ui-stickynote.html">Sticky Note</a></li>
											<li><a href="ui-timeline.html">Timeline</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Charts</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="chart-apex.html">Apex Charts</a></li>
											<li><a href="chart-c3.html">Chart C3</a></li>
											<li><a href="chart-js.html">Chart Js</a></li>
											<li><a href="chart-morris.html">Morris Charts</a></li>
											<li><a href="chart-flot.html">Flot Charts</a></li>
											<li><a href="chart-peity.html">Peity Charts</a></li>
										</ul>
									</li>
									<li class="submenu">
									<a href="javascript:void(0);"><span>Icons</span><span class="menu-arrow"></span></a>
									<ul>
										<li><a href="icon-fontawesome.html">Fontawesome Icons</a></li>
										<li><a href="icon-feather.html">Feather Icons</a></li>
										<li><a href="icon-ionic.html">Ionic Icons</a></li>
										<li><a href="icon-material.html">Material Icons</a></li>
										<li><a href="icon-pe7.html">Pe7 Icons</a></li>
										<li><a href="icon-simpleline.html">Simpleline Icons</a></li>
										<li><a href="icon-themify.html">Themify Icons</a></li>
										<li><a href="icon-weather.html">Weather Icons</a></li>
										<li><a href="icon-typicon.html">Typicon Icons</a></li>
										<li><a href="icon-flag.html">Flag Icons</a></li>
										<li><a href="icon-tabler.html">Tabler Icons</a></li>
										<li><a href="icon-bootstrap.html">Bootstrap Icons</a></li>
										<li><a href="icon-remix.html">Remix Icons</a></li>
									</ul>
								</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span> Forms</span><span class="menu-arrow"></span></a>
										<ul>
											<li class="submenu submenu-two">
												<a href="javascript:void(0);"><span>Form Elements</span><span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="form-basic-inputs.html">Basic Inputs</a></li>
													<li><a href="form-checkbox-radios.html">Checkbox & Radios</a></li>
													<li><a href="form-input-groups.html">Input Groups</a></li>
													<li><a href="form-grid-gutters.html">Grid & Gutters</a></li>
													<li><a href="form-select.html">Form Select</a></li>
													<li><a href="form-mask.html">Input Masks</a></li>
													<li><a href="form-fileupload.html">File Uploads</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two">
												<a href="javascript:void(0);"><span> Layouts</span><span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="form-horizontal.html">Horizontal Form</a></li>
													<li><a href="form-vertical.html">Vertical Form</a></li>
													<li><a href="form-floating-labels.html">Floating Labels</a></li>
												</ul>
											</li>
											<li><a href="form-validation.html">Form Validation</a></li>
											<li><a href="form-select2.html">Select2</a></li>
											<li><a href="form-wizard.html">Form Wizard</a></li>
											<li><a href="form-pickers.html">Form Picker</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Tables</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="tables-basic.html">Basic Tables </a></li>
											<li><a href="data-tables.html">Data Table </a></li>
										</ul>
									</li>
									<li  class="submenu">
										<a href="javascript:void(0);"><span>Maps</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="maps-vector.html">Vector</a></li>
											<li><a href="maps-leaflet.html">Leaflet</a></li>
										</ul>
									</li>
								</ul>
							</li>
							<li class="submenu">
								<a href="javascript:void(0);"><i class="ti ti-page-break fs-16 me-2"></i><span>Pages</span> <span class="menu-arrow"></span></a>
								<ul>
									<li><a href="profile.html"><span>Profile</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Authentication</span><span class="menu-arrow"></span></a>
										<ul>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Login<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="signin.html">Cover</a></li>
													<li><a href="signin-2.html">Illustration</a></li>
													<li><a href="signin-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Register<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="register.html">Cover</a></li>
													<li><a href="register-2.html">Illustration</a></li>
													<li><a href="register-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Forgot Password<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="forgot-password.html">Cover</a></li>
													<li><a href="forgot-password-2.html">Illustration</a></li>
													<li><a href="forgot-password-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Reset Password<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="reset-password.html">Cover</a></li>
													<li><a href="reset-password-2.html">Illustration</a></li>
													<li><a href="reset-password-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Email Verification<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="email-verification.html">Cover</a></li>
													<li><a href="email-verification-2.html">Illustration</a></li>
													<li><a href="email-verification-3.html">Basic</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">2 Step Verification<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="two-step-verification.html">Cover</a></li>
													<li><a href="two-step-verification-2.html">Illustration</a></li>
													<li><a href="two-step-verification-3.html">Basic</a></li>
												</ul>
											</li>
											<li><a href="lock-screen.html">Lock Screen</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Error</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="error-404.html">404 Error </a></li>
											<li><a href="error-500.html">500 Error </a></li>
										</ul>
									</li>
									<li><a href="blank-page.html"><span>Blank Page</span> </a></li>
									<li><a href="pricing.html"><span>Pricing</span> </a></li>
									<li><a href="coming-soon.html"><span>Coming Soon</span> </a></li>
									<li><a href="under-maintenance.html"><span>Under Maintenance</span> </a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Content</span><span class="menu-arrow"></span></a>
										<ul>
											<li class="submenu">
												<a href="javascript:void(0);"><span>Pages</span><span class="menu-arrow"></span></a>
												<ul>
													<li><a href="pages.html">Pages</a></li>
												</ul>
											</li>
											<li class="submenu">
												<a href="javascript:void(0);"><span>Blog</span><span class="menu-arrow"></span></a>
												<ul>
													<li><a href="all-blog.html">All Blog</a></li>
													<li><a href="blog-tag.html">Blog Tags</a></li>
													<li><a href="blog-categories.html">Categories</a></li>
													<li><a href="blog-comments.html">Blog Comments</a></li>
												</ul>
											</li>
											<li class="submenu">
												<a href="javascript:void(0);"><span>Location</span><span class="menu-arrow"></span></a>
												<ul>
													<li><a href="countries.html">Countries</a></li>
													<li><a href="states.html">States</a></li>
													<li><a href="cities.html">Cities</a></li>
												</ul>
											</li>
											<li><a href="testimonials.html"><span>Testimonials</span></a></li>
											<li><a href="faq.html"><span>FAQ</span></a></li>
			
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Employees</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="employees-grid.html"><span>Employees</span></a></li>
											<li><a href="department-grid.html"><span>Departments</span></a></li>
											<li><a href="designation.html"><span>Designation</span></a></li>
											<li><a href="shift.html"><span>Shifts</span></a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Attendence</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="attendance-employee.html">Employee Attendence</a></li>
											<li><a href="attendance-admin.html">Admin Attendence</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Leaves &amp; Holidays</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="leaves-admin.html">Admin Leaves</a></li>
											<li><a href="leaves-employee.html">Employee Leaves</a></li>
											<li><a href="leave-types.html">Leave Types</a></li>
											<li><a href="holidays.html"><span>Holidays</span></a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="employee-salary.html"><span>Payroll</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="employee-salary.html">Employee Salary</a></li>
											<li><a href="payslip.html">Payslip</a></li>
										</ul>
									</li>
								</ul>
							</li>
							<li class="submenu">
								<a href="javascript:void(0);"><i class="ti ti-chart-bar fs-16 me-2"></i><span>Reports</span><span class="menu-arrow"></span></a>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Sales Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="sales-report.html">Sales Report</a></li>
											<li><a href="best-seller.html">Best Seller</a></li>
										</ul>
									</li>
									<li><a href="purchase-report.html"><span>Purchase report</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Inventory Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="inventory-report.html">Inventory Report</a></li>
											<li><a href="stock-history.html">Stock History</a></li>
											<li><a href="sold-stock.html">Sold Stock</a></li>
										</ul>
									</li>
									<li><a href="invoice-report.html"><span>Invoice Report</span></a></li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Supplier Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="supplier-report.html">Supplier Report</a></li>
											<li><a href="supplier-due-report.html">Supplier Due Report</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Customer Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="customer-report.html">Customer Report</a></li>
											<li><a href="customer-due-report.html">Customer Due Report</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Product Report</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="product-report.html">Product Report</a></li>
											<li><a href="product-expiry-report.html">Product Expiry Report</a></li>
											<li><a href="product-quantity-alert.html">Product Quantity Alert</a></li>
										</ul>
									</li>
									<li><a href="expense-report.html"><span>Expense Report</span></a></li>
									<li><a href="income-report.html"><span>Income Report</span></a></li>
									<li><a href="tax-reports.html"><span>Tax Report</span></a></li>
									<li><a href="profit-and-loss.html"><span>Profit & Loss</span></a></li>
									<li><a href="annual-report.html"><span>Annual Report</span></a></li>
								</ul>
							</li>
							<li class="submenu">
								<a href="javascript:void(0);"><i class="ti ti-settings fs-16 me-2"></i><span>Settings</span><span class="menu-arrow"></span></a>
								<ul>
									<li class="submenu">
										<a href="javascript:void(0);"><span>General Settings</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="general-settings.html">Profile</a></li>
											<li><a href="security-settings.html">Security</a></li>
											<li><a href="notification.html">Notifications</a></li>
											<li><a href="connected-apps.html">Connected Apps</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Website Settings</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="system-settings.html">System Settings</a></li>
											<li><a href="company-settings.html">Company Settings </a></li>
											<li><a href="localization-settings.html">Localization</a></li>
											<li><a href="prefixes.html">Prefixes</a></li>
											<li><a href="preference.html">Preference</a></li>
											<li><a href="appearance.html">Appearance</a></li>
											<li><a href="social-authentication.html">Social Authentication</a></li>
											<li><a href="language-settings.html">Language</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>App Settings</span><span class="menu-arrow"></span></a>
										<ul>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Invoice<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="invoice-settings.html">Invoice Settings</a></li>
													<li><a href="invoice-template.html">Invoice Template</a></li>
												</ul>
											</li>
											<li><a href="printer-settings.html">Printer</a></li>
											<li><a href="pos-settings.html">POS</a></li>
											<li><a href="custom-fields.html">Custom Fields</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>System Settings</span><span class="menu-arrow"></span></a>
										<ul>
											<li class="submenu submenu-two"><a href="javascript:void(0);">Email<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="email-settings.html">Email Settings</a></li>
													<li><a href="email-template.html">Email Template</a></li>
												</ul>
											</li>
											<li class="submenu submenu-two"><a href="javascript:void(0);">SMS<span class="menu-arrow inside-submenu"></span></a>
												<ul>
													<li><a href="sms-settings.html">SMS Settings</a></li>
													<li><a href="sms-template.html">SMS Template</a></li>
												</ul>
											</li>
											<li><a href="otp-settings.html">OTP</a></li>
											<li><a href="gdpr-settings.html">GDPR Cookies</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Financial Settings</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="payment-gateway-settings.html">Payment Gateway</a></li>
											<li><a href="bank-settings-grid.html">Bank Accounts</a></li>
											<li><a href="tax-rates.html">Tax Rates</a></li>
											<li><a href="currency-settings.html">Currencies</a></li>
										</ul>
									</li>
									<li class="submenu">
										<a href="javascript:void(0);"><span>Other Settings</span><span class="menu-arrow"></span></a>
										<ul>
											<li><a href="storage-settings.html">Storage</a></li>
											<li><a href="ban-ip-address.html">Ban IP Address</a></li>
										</ul>
									</li>
									<li>
									<a href="signin.html"><span>Logout</span> </a>
								</li>
								</ul>
							</li>
						</ul>
					</div>
				</div>
			</div>
			<!-- /Horizontal Sidebar -->

			<!-- Two Col Sidebar -->
			<div class="two-col-sidebar d-none" id="two-col-sidebar">
				<div class="sidebar sidebar-twocol">
					<div class="twocol-mini">
						<div class="sidebar-left slimscroll">
							<div class="nav flex-column align-items-center nav-pills" id="sidebar-tabs" role="tablist"
								aria-orientation="vertical">
								<a href="#" class="nav-link active" title="Dashboard" data-bs-toggle="tab" data-bs-target="#dashboard">
									<i class="ti ti-smart-home"></i>
								</a>
								<a href="#" class="nav-link " title="Super Admin" data-bs-toggle="tab" data-bs-target="#super-admin">
									<i class="ti ti-user-star"></i>
								</a>
								<a href="#" class="nav-link " title="Apps" data-bs-toggle="tab" data-bs-target="#application">
									<i class="ti ti-layout-grid-add"></i>
								</a>
								<a href="#" class="nav-link" title="Layout" data-bs-toggle="tab" data-bs-target="#layout">
									<i class="ti ti-layout-board-split"></i>
								</a>
								<a href="#" class="nav-link" title="Inventory" data-bs-toggle="tab" data-bs-target="#inventory">
									<i class="ti ti-table-plus"></i>
								</a>
								<a href="#" class="nav-link" title="Stock" data-bs-toggle="tab" data-bs-target="#stock">
									<i class="ti ti-stack-3"></i>
								</a>
								<a href="#" class="nav-link" title="Sales" data-bs-toggle="tab" data-bs-target="#sales">
									<i class="ti ti-device-laptop"></i>
								</a>
								<a href="#" class="nav-link" title="Finance" data-bs-toggle="tab" data-bs-target="#finance">
									<i class="ti ti-shopping-cart-dollar"></i>
								</a>
								<a href="#" class="nav-link" title="Hrm" data-bs-toggle="tab" data-bs-target="#hrm">
									<i class="ti ti-cash"></i>
								</a>
								<a href="#" class="nav-link" title="Reports" data-bs-toggle="tab" data-bs-target="#reports">
									<i class="ti ti-license"></i>
								</a>
								<a href="#" class="nav-link" title="Pages" data-bs-toggle="tab" data-bs-target="#pages">
									<i class="ti ti-page-break"></i>
								</a>
								<a href="#" class="nav-link" title="Settings" data-bs-toggle="tab" data-bs-target="#settings">
									<i class="ti ti-lock-check"></i>
								</a>
								<a href="#" class="nav-link " title="UI Elements" data-bs-toggle="tab" data-bs-target="#ui-elements">
									<i class="ti ti-ux-circle"></i>
								</a>
								<a href="#" class="nav-link" title="Extras" data-bs-toggle="tab" data-bs-target="#extras">
									<i class="ti ti-vector-triangle"></i>
								</a>
							</div>
						</div>
					</div>
					<div class="sidebar-right">
						<!-- Logo -->
						<div class="sidebar-logo">
							<a href="index.html" class="logo logo-normal">
								<img src="{{asset('assets/img/logo.svg')}}" alt="Img">
							</a>
							<a href="index.html" class="logo logo-white">
								<img src="{{asset('assets/img/logo-white.svg')}}" alt="Img">
							</a>
							<a href="index.html" class="logo-small">
								<img src="{{asset('assets/img/logo-small.png')}}" alt="Img">
							</a>
						</div>
						<!-- /Logo -->
						<div class="sidebar-scroll">
							<div class="text-center rounded bg-light p-3 mb-3 border">
								<div class="avatar avatar-lg online mb-3">
									<img src="{{asset('assets/img/customer/customer15.jpg')}}" alt="Img" class="img-fluid rounded-circle">
								</div>
								<h6 class="fs-14 fw-bold mb-1">Adrian Herman</h6>
								<p class="fs-12 mb-0">System Admin</p>
							</div>
							<div class="tab-content" id="v-pills-tabContent">
								<div class="tab-pane fade show active" id="dashboard">
									<ul>
										<li class="menu-title"><span>MAIN</span></li>
										<li><a href="index.html" class="active">Admin Dashboard</a></li>
										<li><a href="admin-dashboard.html">Admin Dashboard 2</a></li>
										<li><a href="sales-dashboard.html">Sales Dashboard</a></li>
									</ul>
								</div>
								<div class="tab-pane fade" id="super-admin">
									<ul>
										<li class="menu-title"><span>SUPER ADMIN</span></li>
										<li><a href="dashboard.html">Dashboard</a></li>
										<li><a href="companies.html">Companies</a></li>
										<li><a href="subscription.html">Subscriptions</a></li>
										<li><a href="packages.html">Packages</a></li>
										<li><a href="domain.html">Domain</a></li>
										<li><a href="purchase-transaction.html">Purchase Transaction</a></li>
									</ul>
								</div>
								<div class="tab-pane fade" id="application">
									<ul>
										<li><a href="chat.html">Chat</a></li>
										<li class="submenu submenu-two"><a href="javascript:void(0);">Call<span class="menu-arrow inside-submenu"></span></a>
											<ul>
												<li><a href="video-call.html">Video Call</a></li>
												<li><a href="audio-call.html">Audio Call</a></li>
												<li><a href="call-history.html">Call History</a></li>
											</ul>
										</li>
										<li><a href="calendar.html">Calendar</a></li>
										<li><a href="contacts.html">Contacts</a></li>
										<li><a href="email.html">Email</a></li>
										<li><a href="todo.html">To Do</a></li>
										<li><a href="notes.html">Notes</a></li>
										<li><a href="file-manager.html">File Manager</a></li>
										<li><a href="projects.html">Projects</a></li>
										<li class="submenu submenu-two"><a href="javascript:void(0);">Ecommerce<span class="menu-arrow inside-submenu"></span></a>
											<ul>
												<li><a href="products.html">Products</a></li>
												<li><a href="orders.html">Orders</a></li>
												<li><a href="customers.html">Customers</a></li>
												<li><a href="cart.html">Cart</a></li>
												<li><a href="checkout.html">Checkout</a></li>
												<li><a href="wishlist.html">Wishlist</a></li>
												<li><a href="reviews.html">Reviews</a></li>
											</ul>
										</li>
										<li><a href="social-feed.html">Social Feed</a></li>
										<li><a href="search-list.html">Search List</a></li>
									</ul>
								</div>
								<div class="tab-pane fade" id="layout">
									<ul>
										<li class="menu-title"><span>LAYOUT</span></li>
										<li><a href="layout-horizontal.html">Horizontal</a></li>
										<li><a href="layout-detached.html">Detached</a></li>
										<li><a href="layout-two-column.html">Two Column</a></li>
										<li><a href="layout-hovered.html">Hovered</a></li>
										<li><a href="layout-boxed.html">Boxed</a></li>
										<li><a href="layout-rtl.html">RTL</a></li>
										<li><a href="layout-dark.html">Dark</a></li>
									</ul>
								</div>
								<div class="tab-pane fade" id="inventory">
									<ul>
										<li class="menu-title"><span>Inventory</span></li>
										<li><a href="product-list.html"><span>Products</span></a></li>
										<li><a href="add-product.html"><span>Create Product</span></a></li>
										<li><a href="expired-products.html"><span>Expired Products</span></a></li>
										<li><a href="low-stocks.html"><span>Low Stocks</span></a></li>
										<li><a href="category-list.html"><span>Category</span></a></li>
										<li><a href="sub-categories.html"><span>Sub Category</span></a></li>
										<li><a href="brand-list.html"><span>Brands</span></a></li>
										<li><a href="units.html"><span>Units</span></a></li>
										<li><a href="varriant-attributes.html"><span>Variant Attributes</span></a></li>
										<li><a href="warranty.html"><span>Warranties</span></a></li>
										<li><a href="barcode.html"><span>Print Barcode</span></a></li>
										<li><a href="qrcode.html"><span>Print QR Code</span></a></li>
									</ul>
								</div>
								<div class="tab-pane fade" id="stock">
									<ul>
										<li class="menu-title"><span>Stock</span></li>
										<li><a href="manage-stocks.html"><span>Manage Stock</span></a></li>
										<li><a href="stock-adjustment.html"><span>Stock Adjustment</span></a></li>
										<li><a href="stock-transfer.html"><span>Stock Transfer</span></a></li>
									</ul>
								</div>
								<div class="tab-pane fade" id="sales">
									<ul>
										<li class="menu-title"><span>Sales</span></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Sales</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="online-orders.html">Online Orders</a></li>
												<li><a href="pos-orders.html">POS Orders</a></li>
											</ul>
										</li>
										<li><a href="invoice.html"><span>Invoices</span></a></li>
										<li><a href="sales-returns.html"><span>Sales Return</span></a></li>
										<li><a href="quotation-list.html"><span>Quotation</span></a></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>POS</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="pos.html">POS 1</a></li>
												<li><a href="pos-2.html">POS 2</a></li>
												<li><a href="pos-3.html">POS 3</a></li>
												<li><a href="pos-4.html">POS 4</a></li>
												<li><a href="pos-5.html">POS 5</a></li>
											</ul>
										</li>
									</ul>
								</div>
								<div class="tab-pane fade" id="finance">
									<ul>
										<li class="menu-title"><span>FINANCE & ACCOUNTS</span></li>
										<li><a href="coupons.html"><span>Coupons</span></a></li>
										<li><a href="gift-cards.html"><span>Gift Cards</span></a></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Discount</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="discount-plan.html">Discount Plan</a></li>
												<li><a href="discount.html">Discount</a></li>
											</ul>
										</li>
										<li><a href="purchase-list.html"><span>Purchases</span></a></li>
										<li><a href="purchase-order-report.html"><span>Purchase Order</span></a></li>
										<li><a href="purchase-returns.html"><span>Purchase Return</span></a></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Expenses</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="expense-list.html">Expenses</a></li>
												<li><a href="expense-category.html">Expense Category</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Income</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="income.html">Income</a></li>
												<li><a href="income-category.html">Income Category</a></li>
											</ul>
										</li>
										<li><a href="account-list.html"><span>Bank Accounts</span></a></li>
										<li><a href="money-transfer.html"><span>Money Transfer</span></a></li>
										<li><a href="balance-sheet.html"><span>Balance Sheet</span></a></li>
										<li><a href="trial-balance.html"><span>Trial Balance</span></a></li>
										<li><a href="cash-flow.html"><span>Cash Flow</span></a></li>
										<li><a href="account-statement.html"><span>Account Statement</span></a></li>
										<li><a href="customers.html"><span>Customers</span></a></li>
										<li><a href="billers.html"><span>Billers</span></a></li>
										<li><a href="suppliers.html"><span>Suppliers</span></a></li>
										<li><a href="store-list.html"><span>Stores</span></a></li>
										<li><a href="warehouse.html"><span>Warehouses</span></a></li>							
									</ul>
								</div>
								<div class="tab-pane fade" id="hrm">
									<ul>
										<li class="menu-title"><span>Hrm</span></li>
										<li><a href="employees-grid.html"><span>Employees</span></a></li>
										<li><a href="department-grid.html"><span>Departments</span></a></li>
										<li><a href="designation.html"><span>Designation</span></a></li>
										<li><a href="shift.html"><span>Shifts</span></a></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Attendence</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="attendance-employee.html">Employee</a></li>
												<li><a href="attendance-admin.html">Admin</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Leaves</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="leaves-admin.html">Admin Leaves</a></li>
												<li><a href="leaves-employee.html">Employee Leaves</a></li>
												<li><a href="leave-types.html">Leave Types</a></li>
											</ul>
										</li>
										<li><a href="holidays.html"><span>Holidays</span></a>
										</li>
										<li class="submenu">
											<a href="employee-salary.html"><span>Payroll</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="employee-salary.html">Employee Salary</a></li>
												<li><a href="payslip.html">Payslip</a></li>
											</ul>
										</li>
									</ul>
								</div>
								<div class="tab-pane fade" id="reports">
									<ul>
										<li class="menu-title"><span>Reports</span></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Sales Report</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="sales-report.html">Sales Report</a></li>
												<li><a href="best-seller.html">Best Seller</a></li>
											</ul>
										</li>
										<li><a href="purchase-report.html"><span>Purchase report</span></a></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Inventory Report</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="inventory-report.html">Inventory Report</a></li>
												<li><a href="stock-history.html">Stock History</a></li>
												<li><a href="sold-stock.html">Sold Stock</a></li>
											</ul>
										</li>
										<li><a href="invoice-report.html"><span>Invoice Report</span></a></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Supplier Report</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="supplier-report.html">Supplier Report</a></li>
												<li><a href="supplier-due-report.html">Supplier Due Report</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Customer Report</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="customer-report.html">Customer Report</a></li>
												<li><a href="customer-due-report.html">Customer Due Report</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Product Report</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="product-report.html">Product Report</a></li>
												<li><a href="product-expiry-report.html">Product Expiry Report</a></li>
												<li><a href="product-quantity-alert.html">Product Quantity Alert</a></li>
											</ul>
										</li>
										<li><a href="expense-report.html"><span>Expense Report</span></a></li>
										<li><a href="income-report.html"><span>Income Report</span></a></li>
										<li><a href="tax-reports.html"><span>Tax Report</span></a></li>
										<li><a href="profit-and-loss.html"><span>Profit & Loss</span></a></li>
										<li><a href="annual-report.html"><span>Annual Report</span></a></li>
									</ul>
								</div>
								<div class="tab-pane fade" id="pages">
									<ul>
										<li class="menu-title"><span>Pages</span></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Pages</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="pages.html">Pages</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Blog</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="all-blog.html">All Blog</a></li>
												<li><a href="blog-tag.html">Blog Tags</a></li>
												<li><a href="blog-categories.html">Categories</a></li>
												<li><a href="blog-comments.html">Blog Comments</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Location</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="countries.html">Countries</a></li>
												<li><a href="states.html">States</a></li>
												<li><a href="cities.html">Cities</a></li>
											</ul>
										</li>
										<li><a href="testimonials.html"><span>Testimonials</span></a></li>
										<li><a href="faq.html"><span>FAQ</span></a></li>
										<li><a href="users.html"><span>Users</span></a></li>
										<li><a href="roles-permissions.html"><span>Roles & Permissions</span></a></li>
										<li><a href="delete-account.html"><span>Delete Account Request</span></a></li>
										<li><a href="profile.html"><span>Profile</span></a></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Authentication</span><span class="menu-arrow"></span></a>
											<ul>
												<li class="submenu submenu-two"><a href="javascript:void(0);">Login<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="signin.html">Cover</a></li>
														<li><a href="signin-2.html">Illustration</a></li>
														<li><a href="signin-3.html">Basic</a></li>
													</ul>
												</li>
												<li class="submenu submenu-two"><a href="javascript:void(0);">Register<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="register.html">Cover</a></li>
														<li><a href="register-2.html">Illustration</a></li>
														<li><a href="register-3.html">Basic</a></li>
													</ul>
												</li>
												<li class="submenu submenu-two"><a href="javascript:void(0);">Forgot Password<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="forgot-password.html">Cover</a></li>
														<li><a href="forgot-password-2.html">Illustration</a></li>
														<li><a href="forgot-password-3.html">Basic</a></li>
													</ul>
												</li>
												<li class="submenu submenu-two"><a href="javascript:void(0);">Reset Password<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="reset-password.html">Cover</a></li>
														<li><a href="reset-password-2.html">Illustration</a></li>
														<li><a href="reset-password-3.html">Basic</a></li>
													</ul>
												</li>
												<li class="submenu submenu-two"><a href="javascript:void(0);">Email Verification<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="email-verification.html">Cover</a></li>
														<li><a href="email-verification-2.html">Illustration</a></li>
														<li><a href="email-verification-3.html">Basic</a></li>
													</ul>
												</li>
												<li class="submenu submenu-two"><a href="javascript:void(0);">2 Step Verification<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="two-step-verification.html">Cover</a></li>
														<li><a href="two-step-verification-2.html">Illustration</a></li>
														<li><a href="two-step-verification-3.html">Basic</a></li>
													</ul>
												</li>
												<li><a href="lock-screen.html">Lock Screen</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Error Pages</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="error-404.html">404 Error </a></li>
												<li><a href="error-500.html">500 Error </a></li>
											</ul>
										</li>
										<li>
											<a href="blank-page.html"><span>Blank Page</span> </a>
										</li>
										<li>
											<a href="pricing.html"><span>Pricing</span> </a>
										</li>
										<li>
											<a href="coming-soon.html"><span>Coming Soon</span> </a>
										</li>
										<li>
											<a href="under-maintenance.html"><span>Under Maintenance</span> </a>
										</li>
									</ul>
								</div>
								<div class="tab-pane fade" id="settings">
									<ul>
										<li class="menu-title"><span>Settings</span></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>General Settings</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="general-settings.html">Profile</a></li>
												<li><a href="security-settings.html">Security</a></li>
												<li><a href="notification.html">Notifications</a></li>
												<li><a href="connected-apps.html">Connected Apps</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Website Settings</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="system-settings.html">System Settings</a></li>
												<li><a href="company-settings.html">Company Settings </a></li>
												<li><a href="localization-settings.html">Localization</a></li>
												<li><a href="prefixes.html">Prefixes</a></li>
												<li><a href="preference.html">Preference</a></li>
												<li><a href="appearance.html">Appearance</a></li>
												<li><a href="social-authentication.html">Social Authentication</a></li>
												<li><a href="language-settings.html">Language</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);">
												<span>App Settings</span><span class="menu-arrow"></span>
											</a>
											<ul>
												<li class="submenu submenu-two"><a href="javascript:void(0);">Invoice<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="invoice-settings.html">Invoice Settings</a></li>
														<li><a href="invoice-template.html">Invoice Template</a></li>
													</ul>
												</li>
												<li><a href="printer-settings.html">Printer</a></li>
												<li><a href="pos-settings.html">POS</a></li>
												<li><a href="custom-fields.html">Custom Fields</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);">
												<span>System Settings</span><span class="menu-arrow"></span>
											</a>
											<ul>
												<li class="submenu submenu-two"><a href="javascript:void(0);">Email<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="email-settings.html">Email Settings</a></li>
														<li><a href="email-template.html">Email Template</a></li>
													</ul>
												</li>
												<li class="submenu submenu-two"><a href="javascript:void(0);">SMS<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="sms-settings.html">SMS Settings</a></li>
														<li><a href="sms-template.html">SMS Template</a></li>
													</ul>
												</li>
												<li><a href="otp-settings.html">OTP</a></li>
												<li><a href="gdpr-settings.html">GDPR Cookies</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);">
												<span>Financial Settings</span><span class="menu-arrow"></span>
											</a>
											<ul>
												<li><a href="payment-gateway-settings.html">Payment Gateway</a></li>
												<li><a href="bank-settings-grid.html">Bank Accounts</a></li>
												<li><a href="tax-rates.html">Tax Rates</a></li>
												<li><a href="currency-settings.html">Currencies</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);">
												<span>Other Settings</span><span class="menu-arrow"></span>
											</a>
											<ul>
												<li><a href="storage-settings.html">Storage</a></li>
												<li><a href="ban-ip-address.html">Ban IP Address</a></li>
											</ul>
										</li>
										<li>
											<a href="signin.html"><span>Logout</span> </a>
										</li>
									</ul>
								</div>
								<div class="tab-pane fade" id="ui-elements">
									<ul>
										<li class="menu-title"><span>Ui Interface</span></li>
										<li class="submenu">
											<a href="javascript:void(0);">
												<span>Base UI</span><span class="menu-arrow"></span>
											</a>
											<ul>
												<li><a href="ui-alerts.html">Alerts</a></li>
												<li><a href="ui-accordion.html">Accordion</a></li>
												<li><a href="ui-avatar.html">Avatar</a></li>
												<li><a href="ui-badges.html">Badges</a></li>
												<li><a href="ui-borders.html">Border</a></li>
												<li><a href="ui-buttons.html">Buttons</a></li>
												<li><a href="ui-buttons-group.html">Button Group</a></li>
												<li><a href="ui-breadcrumb.html">Breadcrumb</a></li>
												<li><a href="ui-cards.html">Card</a></li>
												<li><a href="ui-carousel.html">Carousel</a></li>
												<li><a href="ui-colors.html">Colors</a></li>
												<li><a href="ui-dropdowns.html">Dropdowns</a></li>
												<li><a href="ui-grid.html">Grid</a></li>
												<li><a href="ui-images.html">Images</a></li>
												<li><a href="ui-lightbox.html">Lightbox</a></li>
												<li><a href="ui-media.html">Media</a></li>
												<li><a href="ui-modals.html">Modals</a></li>
												<li><a href="ui-offcanvas.html">Offcanvas</a></li>
												<li><a href="ui-pagination.html">Pagination</a></li>
												<li><a href="ui-popovers.html">Popovers</a></li>
												<li><a href="ui-progress.html">Progress</a></li>
												<li><a href="ui-placeholders.html">Placeholders</a></li>
												<li><a href="ui-rangeslider.html">Range Slider</a></li>
												<li><a href="ui-spinner.html">Spinner</a></li>
												<li><a href="ui-sweetalerts.html">Sweet Alerts</a></li>
												<li><a href="ui-nav-tabs.html">Tabs</a></li>
												<li><a href="ui-toasts.html">Toasts</a></li>
												<li><a href="ui-tooltips.html">Tooltips</a></li>
												<li><a href="ui-typography.html">Typography</a></li>
												<li><a href="ui-video.html">Video</a></li>
												<li><a href="ui-sortable.html">Sortable</a></li>
												<li><a href="ui-swiperjs.html">Swiperjs</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);">
												<span>Advanced UI</span><span class="menu-arrow"></span>
											</a>
											<ul>
												<li><a href="ui-ribbon.html">Ribbon</a></li>
												<li><a href="ui-clipboard.html">Clipboard</a></li>
												<li><a href="ui-drag-drop.html">Drag & Drop</a></li>
												<li><a href="ui-rangeslider.html">Range Slider</a></li>
												<li><a href="ui-rating.html">Rating</a></li>
												<li><a href="ui-text-editor.html">Text Editor</a></li>
												<li><a href="ui-counter.html">Counter</a></li>
												<li><a href="ui-scrollbar.html">Scrollbar</a></li>
												<li><a href="ui-stickynote.html">Sticky Note</a></li>
												<li><a href="ui-timeline.html">Timeline</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);">
												<span>Charts</span><span class="menu-arrow"></span>
											</a>
											<ul>
												<li><a href="chart-apex.html">Apex Charts</a></li>
												<li><a href="chart-c3.html">Chart C3</a></li>
												<li><a href="chart-js.html">Chart Js</a></li>
												<li><a href="chart-morris.html">Morris Charts</a></li>
												<li><a href="chart-flot.html">Flot Charts</a></li>
												<li><a href="chart-peity.html">Peity Charts</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);">
												<span>Icons</span><span class="menu-arrow"></span>
											</a>
											<ul>
												<li><a href="icon-fontawesome.html">Fontawesome Icons</a></li>
												<li><a href="icon-feather.html">Feather Icons</a></li>
												<li><a href="icon-ionic.html">Ionic Icons</a></li>
												<li><a href="icon-material.html">Material Icons</a></li>
												<li><a href="icon-pe7.html">Pe7 Icons</a></li>
												<li><a href="icon-simpleline.html">Simpleline Icons</a></li>
												<li><a href="icon-themify.html">Themify Icons</a></li>
												<li><a href="icon-weather.html">Weather Icons</a></li>
												<li><a href="icon-typicon.html">Typicon Icons</a></li>
												<li><a href="icon-flag.html">Flag Icons</a></li>
												<li><a href="icon-tabler.html">Tabler Icons</a></li>
												<li><a href="icon-bootstrap.html">Bootstrap Icons</a></li>
												<li><a href="icon-remix.html">Remix Icons</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);">
												<span>Forms</span><span class="menu-arrow"></span>
											</a>
											<ul>
												<li class="submenu submenu-two">
													<a href="javascript:void(0);">Form Elements<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="form-basic-inputs.html">Basic Inputs</a></li>
														<li><a href="form-checkbox-radios.html">Checkbox & Radios</a></li>
														<li><a href="form-input-groups.html">Input Groups</a></li>
														<li><a href="form-grid-gutters.html">Grid & Gutters</a></li>
														<li><a href="form-select.html">Form Select</a></li>
														<li><a href="form-mask.html">Input Masks</a></li>
														<li><a href="form-fileupload.html">File Uploads</a></li>
													</ul>
												</li>
												<li class="submenu submenu-two">
													<a href="javascript:void(0);">Layouts<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="form-horizontal.html">Horizontal Form</a></li>
														<li><a href="form-vertical.html">Vertical Form</a></li>
														<li><a href="form-floating-labels.html">Floating Labels</a></li>
													</ul>
												</li>
												<li><a href="form-validation.html">Form Validation</a></li>
												<li><a href="form-select2.html">Select2</a></li>
												<li><a href="form-wizard.html">Form Wizard</a></li>
												<li><a href="form-pickers.html">Form Picker</a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Tables</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="tables-basic.html">Basic Tables </a></li>
												<li><a href="data-tables.html">Data Table </a></li>
											</ul>
										</li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Maps</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="maps-vector.html">Vector</a></li>
												<li><a href="maps-leaflet.html">Leaflet</a></li>
											</ul>
										</li>
									</ul>
								</div>
								<div class="tab-pane fade" id="extras">
									<ul>
										<li class="menu-title"><span>Help</span></li>
										<li><a href="javascript:void(0);"><span>Documentation</span></a></li>
										<li><a href="javascript:void(0);"><span>Changelog v2.1.3</span></a></li>
										<li class="submenu">
											<a href="javascript:void(0);"><span>Multi Level</span><span class="menu-arrow"></span></a>
											<ul>
												<li><a href="javascript:void(0);">Level 1.1</a></li>
												<li class="submenu submenu-two"><a href="javascript:void(0);">Level 1.2<span class="menu-arrow inside-submenu"></span></a>
													<ul>
														<li><a href="javascript:void(0);">Level 2.1</a></li>
														<li class="submenu submenu-two submenu-three"><a href="javascript:void(0);">Level 2.2<span class="menu-arrow inside-submenu inside-submenu-two"></span></a>
															<ul>
																<li><a href="javascript:void(0);">Level 3.1</a></li>
																<li><a href="javascript:void(0);">Level 3.2</a></li>
															</ul>
														</li>
													</ul>
												</li>
											</ul>
										</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- /Two Col Sidebar -->
			
			<div class="page-wrapper pos-pg-wrapper ms-0">
				<div class="content pos-design p-0">

					<div class="row align-items-start pos-wrapper">

						<!-- Products -->
						<div class="col-md-12 col-lg-7 col-xl-8">
							<div class="pos-categories tabs_wrapper pb-0">
								<div class="card pos-button">
									<div class="d-flex align-items-center flex-wrap">
										<a href="javascript:void(0);" class="btn btn-teal btn-md mb-xs-3" data-bs-toggle="modal" data-bs-target="#orders"><i class="ti ti-shopping-cart me-1"></i>View Orders</a>
										<a href="javascript:void(0);" class="btn btn-md btn-indigo" data-bs-toggle="modal" data-bs-target="#reset"><i class="ti ti-reload me-1"></i>Reset</a>
										<a href="javascript:void(0);" class="btn btn-md btn-info" data-bs-toggle="modal" data-bs-target="#recents"><i class="ti ti-refresh-dot me-1"></i>Transaction</a>
									</div>
								</div>
								<div class="d-flex align-items-center justify-content-between">
									<h4 class="mb-3">Categories</h4>
								</div>
								<ul class="tabs owl-carousel pos-category">
									<li id="all" class="category-filter active" data-category="all">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-01.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">All Categories</a></h6>
										<span>@php echo count($productsCategories); @endphp Items</span>
									</li>
                                    @php $i=0; @endphp
                                    @foreach($productsCategories as $productsCategory)
									<li class="category-filter" data-category="{{ strtolower(trim(preg_replace('/\s+/', ' ', $productsCategory['name']))) }}" id="{{$i}}">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-08.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">{{$productsCategory['name']}}</a></h6>
										<span>{{$productsCategory['count']}} Products</span>
									</li>
                                    @php $i++; @endphp
                                    @endforeach
									{{--<li id="shoes">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-13.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">Shoes</a></h6>
										<span>14 Items</span>
									</li>
									<li id="mobiles">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-09.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">Mobiles</a></h6>
										<span>7 Items</span>
									</li>
									<li id="watches">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-11.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">Watches</a></h6>
										<span>16 Items</span>
									</li>
									<li id="laptops">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-12.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">Laptops</a></h6>
										<span>18 Items</span>
									</li>
									<li id="allcategory">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-06.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">All Categories</a></h6>
										<span>80 Items</span>
									</li>
									<li id="headphone">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-05.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">Headphones</a></h6>
										<span>4 Items</span>
									</li>
									<li id="shoe">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-04.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">Shoes</a></h6>
										<span>14 Items</span>
									</li>
									<li id="mobile">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-01.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">Mobiles</a></h6>
										<span>7 Items</span>
									</li>
									<li id="watche">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-11.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">Watches</a></h6>
										<span>16 Items</span>
									</li>
									<li id="laptop">
										<a href="javascript:void(0);">
											<img src="{{asset('assets/img/products/pos-product-02.png')}}" alt="Categories">
										</a>
										<h6><a href="javascript:void(0);">Laptops</a></h6>
										<span>18 Items</span>
									</li>--}}
								</ul>
								<div class="pos-products">
									<div class="d-flex align-items-center justify-content-between">
										<h4 class="mb-3">Products</h4>
										<div class="input-icon-start pos-search position-relative mb-3">
											<span class="input-icon-addon">
												<i class="ti ti-search"></i>
											</span>
											<input type="text" class="form-control" placeholder="Search Product" id="search-products">
										</div>
									</div>
									<div class="tabs_container">
										<div  class="tab_content active" data-tab="all">
											<div class="row">
                                                {{-- products list here --}}
                                                @if(isset($products) && !empty($products))
                                                @foreach($products as $product)
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">  
													<div class="product-info card" @if($product['extra_dt'] == 1 && ($product['hasOp'] == 1 || $product['hasAd'] == 1)) data-hasDetail="1" @else data-hasDetail="0" @endif data-name="{{$product['name']}}" data-image="{{$product['image']}}" data-pro-id="{{$product['id']}}" data-price="@if($product['price_after_offer'] > 0){{$product['price_after_offer']}}@else{{$product['price']}}@endif" data-category="{{ strtolower(trim(preg_replace('/\s+/', ' ', $product['product_category_name']))) }}">
														<a href="javascript:void(0);" class="pro-img img-set-a">
															<img src="{{$product['image']}}" alt="Products" class="img-set">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">{{$product['product_category_name']}}</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">{{$product['name']}}</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
                                                            @if($product['limited_quantity'] == 1)
															<span>{{$product['available_quantity']}}</span>
                                                            @elseif($product['limited_quantity'] == 2)
                                                            <span>Unlimited Quantity</span>
                                                            @endif
                                                            @if($product['price_after_offer'] > 0)
															<p>{{$product['price_after_offer']}}QAR</p>
                                                            @elseif($product['price'] > 0)
                                                            <p>{{$product['price']}}QAR</p>
                                                            @endif
														</div>
													</div>
												</div>
                                                @endforeach
                                                @else
                                                <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                                                    <p>--No Products--</p>
                                                </div>
                                                @endif
                                                {{-- prodducts list end here --}}
												{{--<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-02.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Computer</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">MacBook Pro</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>140 Pcs</span>
															<p>$1000</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-03.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Rolex Tribute V3</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>220 Pcs</span>
															<p>$6800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-04.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Red Nike Angelo</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>78 Pcs</span>
															<p>$7800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card active">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-05.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Headphones</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Airpod 2</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>47 Pcs</span>
															<p>$5478</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-06.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Blue White OGR</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>54 Pcs</span>
															<p>$987</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-07.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Laptop</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">IdeaPad Slim 5 Gen 7</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>74 Pcs</span>
															<p>$1454</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-08.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Headphones</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">SWAGME</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$6587</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-09.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Timex Black Silver</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>24 Pcs</span>
															<p>$1457</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-10.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Computer</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Tablet 1.02 inch</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$4744</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-11.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Fossil Pair Of 3 in 1 </a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>40 Pcs</span>
															<p>$789</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-13.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Green Nike Fe</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>78 Pcs</span>
															<p>$7847</p>
														</div>
													</div>
												</div>--}}

											</div>
										</div>
										<div  class="tab_content" data-tab="headphones">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-05.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Headphones</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Airpod 2</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>47 Pcs</span>
															<p>$5478</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-08.png')}}" alt="Products">
															<span><i data-feather="check" class="feather-16" ></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Headphones</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">SWAGME</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$6587</p>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div  class="tab_content" data-tab="shoes">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-04.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Red Nike Angelo</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>78 Pcs</span>
															<p>$7800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-06.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Blue White OGR</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>54 Pcs</span>
															<p>$987</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-13.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Green Nike Fe</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>78 Pcs</span>
															<p>$7847</p>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div  class="tab_content" data-tab="mobiles">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-01.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Mobiles</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">IPhone 14 64GB</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>30 Pcs</span>
															<p>$15800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-14.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Mobiles</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Iphone 11</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$3654</p>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div  class="tab_content" data-tab="watches">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-03.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Rolex Tribute V3</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>220 Pcs</span>
															<p>$6800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-09.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Timex Black Silver</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>24 Pcs</span>
															<p>$1457</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-11.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Fossil Pair Of 3 in 1 </a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>40 Pcs</span>
															<p>$789</p>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div  class="tab_content" data-tab="laptops">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-02.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Computer</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">MacBook Pro</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>140 Pcs</span>
															<p>$1000</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-07.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Laptop</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">IdeaPad Slim 5 Gen 7</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>74 Pcs</span>
															<p>$1454</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-10.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Computer</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Tablet 1.02 inch</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$4744</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-13.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Laptop</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Yoga Book 9i</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>65 Pcs</span>
															<p>$4784</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-14.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Laptop</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">IdeaPad Slim 3i</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>47 Pcs</span>
															<p>$1245</p>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div  class="tab_content" data-tab="allcategory">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-01.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Mobiles</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">IPhone 14 64GB</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>30 Pcs</span>
															<p>$15800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-02.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Computer</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">MacBook Pro</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>140 Pcs</span>
															<p>$1000</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-03.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Rolex Tribute V3</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>220 Pcs</span>
															<p>$6800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-04.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Red Nike Angelo</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>78 Pcs</span>
															<p>$7800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-05.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Headphones</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Airpod 2</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>47 Pcs</span>
															<p>$5478</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-06.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Blue White OGR</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>54 Pcs</span>
															<p>$987</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-07.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Laptop</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">IdeaPad Slim 5 Gen 7</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>74 Pcs</span>
															<p>$1454</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-08.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Headphones</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">SWAGME</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$6587</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-09.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Timex Black Silver</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>24 Pcs</span>
															<p>$1457</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-10.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Computer</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Tablet 1.02 inch</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$4744</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-11.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Fossil Pair Of 3 in 1 </a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>40 Pcs</span>
															<p>$789</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-13.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Green Nike Fe</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>78 Pcs</span>
															<p>$7847</p>
														</div>
													</div>
												</div>

											</div>
										</div>
										<div  class="tab_content" data-tab="headphone">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-05.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Headphones</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Airpod 2</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>47 Pcs</span>
															<p>$5478</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-08.png')}}" alt="Products">
															<span><i data-feather="check" class="feather-16" ></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Headphones</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">SWAGME</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$6587</p>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div  class="tab_content" data-tab="shoe">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-04.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Red Nike Angelo</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>78 Pcs</span>
															<p>$7800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-06.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Blue White OGR</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>54 Pcs</span>
															<p>$987</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-13.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Shoes</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Green Nike Fe</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>78 Pcs</span>
															<p>$7847</p>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div  class="tab_content" data-tab="mobile">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-01.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Mobiles</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">IPhone 14 64GB</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>30 Pcs</span>
															<p>$15800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-14.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Mobiles</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Iphone 11</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$3654</p>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div  class="tab_content" data-tab="watche">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-03.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Rolex Tribute V3</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>220 Pcs</span>
															<p>$6800</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-09.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Timex Black Silver</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>24 Pcs</span>
															<p>$1457</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-11.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Watches</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Fossil Pair Of 3 in 1 </a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>40 Pcs</span>
															<p>$789</p>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div  class="tab_content" data-tab="laptop">
											<div class="row">
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-02.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Computer</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">MacBook Pro</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>140 Pcs</span>
															<p>$1000</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-07.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Laptop</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">IdeaPad Slim 5 Gen 7</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>74 Pcs</span>
															<p>$1454</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-10.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Computer</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Tablet 1.02 inch</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>14 Pcs</span>
															<p>$4744</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-13.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Laptop</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">Yoga Book 9i</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>65 Pcs</span>
															<p>$4784</p>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
													<div class="product-info card">
														<a href="javascript:void(0);" class="pro-img">
															<img src="{{asset('assets/img/products/pos-product-14.png')}}" alt="Products">
															<span><i class="ti ti-circle-check-filled"></i></span>
														</a>
														<h6 class="cat-name"><a href="javascript:void(0);">Laptop</a></h6>
														<h6 class="product-name"><a href="javascript:void(0);">IdeaPad Slim 3i</a></h6>
														<div class="d-flex align-items-center justify-content-between price">
															<span>47 Pcs</span>
															<p>$1245</p>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!-- /Products -->

						<!-- Order Details -->
						<div class="col-md-12 col-lg-5 col-xl-4 ps-0 theiaStickySidebar">
							<aside class="product-order-list">
								<div class="order-head bg-light d-flex align-items-center justify-content-between w-100">
									<div>
										<h3>Order List</h3>
										<span>Transaction ID : #65565</span>
									</div>
									<div>
										<a class="link-danger fs-16" href="javascript:void(0);"><i class="ti ti-trash-x-filled"></i></a>
									</div>
								</div>
								<div class="customer-info block-section">
									<h4 class="mb-3">Customer Information</h4>
									<div class="input-block d-flex align-items-center">
										<div class="flex-grow-1">
											<select class="select">
												<option>Walk in Customer</option>
												<option>John</option>
												<option>Smith</option>
												<option>Ana</option>
												<option>Elza</option>
											</select>
										</div>
										<a href="#" class="btn btn-primary btn-icon" data-bs-toggle="modal" data-bs-target="#create"><i data-feather="user-plus" class="feather-16"></i></a>
									</div>
									<div class="input-block">
										{{--<select class="select">
											<option>Search Products</option>
											<option>IPhone 14 64GB</option>
											<option>MacBook Pro</option>
											<option>Rolex Tribute V3</option>
											<option>Red Nike Angelo</option>
											<option>Airpod 2</option>
											<option>Oldest</option>
										</select>--}}
										<input type="text" class="form-control" placeholder="Search Product" id="search-cart">
									</div>
								</div>
								<div class="product-added block-section">
									<div class="head-text d-flex align-items-center justify-content-between">
										<h5 class="d-flex align-items-center mb-0">Product Added<span class="count">2</span></h5>
										<a href="javascript:void(0);" class="d-flex align-items-center link-danger" id="clear-cart"><span class="me-2"><i data-feather="x" class="feather-16"></i></span>Clear all</a>
									</div>
                                    {{--<div class="empty-cart">
										<div class="fs-24 mb-1">
											<i class="ti ti-shopping-cart"></i>
										</div>
										<p class="fw-bold">No Products Selected</p>
									</div>--}}
									<div class="product-wrap cart-list">
										{{--<div class="product-list align-items-center justify-content-between">
											<div class="d-flex align-items-center product-info">
												<a href="javascript:void(0);" class="pro-img">
													<img src="{{asset('assets/img/products/pos-product-04.png')}}" alt="Products">
												</a>
												<div class="info">
													<span>PT0005</span>
													<h6><a href="javascript:void(0);">Red Nike Laser</a></h6>
													<p class="fw-bold text-teal">$2000</p>
												</div>
											</div>
											<div class="qty-item text-center">
										        <a href="javascript:void(0);" class="dec d-flex justify-content-center align-items-center" data-bs-toggle="tooltip" data-bs-placement="top" title="minus"><i data-feather="minus-circle" class="feather-14"></i></a>
										        <input type="text" class="form-control text-center" name="qty" value="4">
										        <a href="javascript:void(0);" class="inc d-flex justify-content-center align-items-center" data-bs-toggle="tooltip" data-bs-placement="top" title="plus"><i data-feather="plus-circle" class="feather-14"></i></a>
		    								</div>
											<div class="d-flex align-items-center action">
												<a class="btn-icon edit-icon me-1" href="#" data-bs-toggle="modal"
													data-bs-target="#edit-product">
													<i data-feather="edit" class="feather-14"></i>
												</a>
												<a class="btn-icon delete-icon" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#delete">
													<i data-feather="trash-2" class="feather-14"></i>
												</a>
											</div>
										</div>
										<div class="product-list ms-3 align-items-center justify-content-between">
											<div class="d-flex align-items-center product-info" data-bs-toggle="modal" data-bs-target="#products">
												<a href="javascript:void(0);" class="pro-img">
													<img src="{{asset('assets/img/products/pos-product-10.png')}}" alt="Products">
												</a>
												<div class="info">
													<span>PT0235</span>
													<h6><a href="javascript:void(0);">Iphone 14</a></h6>
													<p class="fw-bold text-teal">$3000</p>
												</div>
											</div>
											<div class="qty-item text-center">
										        <a href="javascript:void(0);" class="dec d-flex justify-content-center align-items-center" data-bs-toggle="tooltip" data-bs-placement="top" title="minus"><i data-feather="minus-circle" class="feather-14"></i></a>
										        <input type="text" class="form-control text-center" name="qty" value="3">
										        <a href="javascript:void(0);" class="inc d-flex justify-content-center align-items-center" data-bs-toggle="tooltip" data-bs-placement="top" title="plus"><i data-feather="plus-circle" class="feather-14"></i></a>
		    								</div>
											<div class="d-flex align-items-center action">
												<a class="btn-icon edit-icon me-1" href="#" data-bs-toggle="modal" data-bs-target="#edit-product">
													<i data-feather="edit" class="feather-14"></i>
												</a>
												<a class="btn-icon delete-icon" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#delete">
													<i data-feather="trash-2" class="feather-14"></i>
												</a>
											</div>
										</div>
										<div class="product-list align-items-center justify-content-between">
											<div class="d-flex align-items-center product-info" data-bs-toggle="modal" data-bs-target="#products">
												<a href="javascript:void(0);" class="pro-img">
													<img src="{{asset('assets/img/products/pos-product-09.png')}}" alt="Products">
												</a>
												<div class="info">
													<span>PT0242</span>
													<h6><a href="javascript:void(0);">Timex Black Silver</a></h6>
													<p class="fw-bold text-teal">$1457</p>
												</div>
											</div>
											<div class="qty-item text-center">
										        <a href="javascript:void(0);" class="dec d-flex justify-content-center align-items-center" data-bs-toggle="tooltip" data-bs-placement="top" title="minus"><i data-feather="minus-circle" class="feather-14"></i></a>
										        <input type="text" class="form-control text-center" name="qty" value="1">
										        <a href="javascript:void(0);" class="inc d-flex justify-content-center align-items-center" data-bs-toggle="tooltip" data-bs-placement="top" title="plus"><i data-feather="plus-circle" class="feather-14"></i></a>
		    								</div>
											<div class="d-flex align-items-center action">
												<a class="btn-icon edit-icon me-1" href="#" data-bs-toggle="modal"
													data-bs-target="#edit-product">
													<i data-feather="edit" class="feather-14"></i>
												</a>
												<a class="btn-icon delete-icon" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#delete">
													<i data-feather="trash-2" class="feather-14"></i>
												</a>
											</div>
										</div>
										<div class="product-list align-items-center justify-content-between">
											<div class="d-flex align-items-center product-info" data-bs-toggle="modal" data-bs-target="#products">
												<a href="javascript:void(0);" class="pro-img">
													<img src="{{asset('assets/img/products/pos-product-08.png')}}" alt="Products">
												</a>
												<div class="info">
													<span>PT0005</span>
													<h6><a href="javascript:void(0);">SWAGME</a></h6>
													<p class="fw-bold text-teal">$6587</p>
												</div>
											</div>
											<div class="qty-item text-center">
										        <a href="javascript:void(0);" class="dec d-flex justify-content-center align-items-center" data-bs-toggle="tooltip" data-bs-placement="top" title="minus"><i data-feather="minus-circle" class="feather-14"></i></a>
										        <input type="text" class="form-control text-center" name="qty" value="1">
										        <a href="javascript:void(0);" class="inc d-flex justify-content-center align-items-center" data-bs-toggle="tooltip" data-bs-placement="top" title="plus"><i data-feather="plus-circle" class="feather-14"></i></a>
		    								</div>
											<div class="d-flex align-items-center action">
												<a class="btn-icon edit-icon me-1" href="#" data-bs-toggle="modal"
													data-bs-target="#edit-product">
													<i data-feather="edit" class="feather-14"></i>
												</a>
												<a class="btn-icon delete-icon" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#delete">
													<i data-feather="trash-2" class="feather-14"></i>
												</a>
											</div>
										</div>--}}
									</div>
								</div>
								<div class="block-section">
									<div class="selling-info">
										<div class="row g-3">
											{{--<div class="col-12 col-sm-4">
												<div>
													<label class="form-label">Order Tax</label>
													<select class="select">
														<option>Select</option>
														<option>GST 5%</option>
														<option>GST 10%</option>
														<option>GST 15%</option>
														<option>GST 20%</option>
														<option>GST 25%</option>
														<option>GST 30%</option>
													</select>
												</div>
											</div>
											<div class="col-12 col-sm-4">
												<div>
													<label class="form-label">Shipping</label>
													<select class="select">
														<option>0</option>
														<option>15</option>
														<option>20</option>
														<option>25</option>
														<option>30</option>
													</select>
												</div>
											</div>--}}
											<div class="col-12 col-sm-12">
												<div>
													<label class="form-label">Discount</label>
													<select class="select" id="selectTotalDiscount">
														<option value="0">0%</option>
														<option value="10">10%</option>
														<option value="15">15%</option>
														<option value="20">20%</option>
														<option value="25">25%</option>
														<option value="30">30%</option>
														<option value="35">35%</option>
													</select>
												</div>
											</div>
										</div>
									</div>
									<div class="order-total">
										<table class="table table-responsive table-borderless">
											<tr>
												<td>Sub Total</td>
												<td class="text-end" id="subTotal"></td>
											</tr>
											{{--<tr>
												<td>Tax (GST 5%)</td>
												<td class="text-end">$40.21</td>
											</tr>
											<tr>
												<td>Shipping</td>
												<td class="text-end">$40.21</td>
											</tr>
											<tr>
												<td>Sub Total</td>
												<td class="text-end">$60,454</td>
											</tr>--}}
											<tr>
												<td class="text-danger">Discount</td>
												<td class="text-danger text-end" id="totalDiscount"></td>
											</tr>
											<tr>
												<td>Total</td>
												<td class="text-end" id="totalPrice"></td>
											</tr>
										</table>
									</div>
								</div>
								<div class="block-section payment-method">
									<h4>Payment Method</h4>
									<div class="row align-items-center justify-content-center methods g-3">
										<div class="col-sm-6 col-md-4">
											<a href="javascript:void(0);" class="payment-item" payment-item="cash" {{--data-bs-toggle="modal" data-bs-target="#payment-cash"--}}>
												<i class="ti ti-cash-banknote fs-18"></i>
												<span>Cash</span>
											</a>
										</div>
										<div class="col-sm-6 col-md-4">
											<a href="javascript:void(0);" class="payment-item" payment-item="online" {{--data-bs-toggle="modal" data-bs-target="#payment-card"--}}>
												<i class="ti ti-credit-card fs-18"></i>
												<span>Debit Card</span>
											</a>
										</div>
										<div class="col-sm-6 col-md-4">
											<a href="javascript:void(0);" class="payment-item" payment-item="scan" {{--data-bs-toggle="modal" data-bs-target="#scan-payment"--}}>
												<i class="ti ti-scan fs-18"></i>
												<span>Scan</span>
											</a>
										</div>
									</div>
								</div>
								<div class="btn-block">
									<a class="btn btn-secondary w-100" href="javascript:void(0);" id="checkout-btn">
										{{--Grand Total : $64,024.5--}} CheckOut
									</a>
								</div>
								<div class="btn-row d-sm-flex align-items-center justify-content-between">
									<a href="javascript:void(0);" class="btn btn-purple d-flex align-items-center justify-content-center flex-fill" data-bs-toggle="modal" data-bs-target="#hold-order"><i  class="ti ti-player-pause me-1"></i>Hold</a>
									<a href="javascript:void(0);" class="btn btn-danger d-flex align-items-center justify-content-center flex-fill"><i  class="ti ti-trash me-1"></i>Void</a>
									<a href="javascript:void(0);" class="btn btn-success d-flex align-items-center justify-content-center flex-fill" data-bs-toggle="modal" data-bs-target="#payment-completed"><i  class="ti ti-cash-banknote me-1"></i>Payment</a>
								</div>
							</aside>
						</div>
						<!-- /Order Details -->

					</div>
				</div>
			</div>

		</div>
		<!-- /Main Wrapper -->

		<!-- Payment Completed -->
		<div class="modal fade modal-default" id="payment-completed" aria-labelledby="payment-completed">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-body p-0">
						<div class="success-wrap text-center">
							<form action="pos-2.html">
								<div class="icon-success bg-success text-white mb-2">
									<i class="ti ti-check"></i>
								</div>
								<h3 class="mb-2">Payment Completed</h3>
								<p class="mb-3">Do you want to Print Receipt for the Completed Order</p>
								<div class="d-flex align-items-center justify-content-center gap-2 flex-wrap">
									<button type="button" class="btn btn-md btn-secondary" data-bs-toggle="modal" data-bs-target="#print-receipt">Print Receipt<i class="feather-arrow-right-circle icon-me-5"></i></button>
									<button type="submit" class="btn btn-md btn-primary">Next Order</button>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Payment Completed -->

		<!-- Print Receipt -->
		<div class="modal fade modal-default" id="print-receipt" aria-labelledby="print-receipt">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-body">
						<div class="icon-head text-center">
							<a href="javascript:void(0);">
								<img src="{{asset('assets/img/logo.svg')}}" width="100" height="30" alt="Receipt Logo">
							</a>
						</div>
						<div class="text-center info text-center">
							<h6>Dreamguys Technologies Pvt Ltd.,</h6>
							<p class="mb-0">Phone Number: +1 5656665656</p>
							<p class="mb-0">Email: <a href="mailto:example@gmail.com">example@gmail.com</a></p>
						</div>
						<div class="tax-invoice">
							<h6 class="text-center">Tax Invoice</h6>
							<div class="row">
								<div class="col-sm-12 col-md-6">
									<div class="invoice-user-name"><span>Name: </span>John Doe</div>
									<div class="invoice-user-name"><span>Invoice No: </span>CS132453</div>
								</div>
								<div class="col-sm-12 col-md-6">
									<div class="invoice-user-name"><span>Customer Id: </span>#LL93784</div>
									<div class="invoice-user-name"><span>Date: </span>01.07.2022</div>
								</div>
							</div>
						</div>
						<table class="table-borderless w-100 table-fit">
							<thead>
								<tr>
									<th># Item</th>
									<th>Price</th>
									<th>Qty</th>
									<th class="text-end">Total</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>1. Red Nike Laser</td>
									<td>$50</td>
									<td>3</td>
									<td class="text-end">$150</td>
								</tr>
								<tr>
									<td>2. Iphone 14</td>
									<td>$50</td>
									<td>2</td>
									<td class="text-end">$100</td>
								</tr>
								<tr>
									<td>3. Apple Series 8</td>
									<td>$50</td>
									<td>3</td>
									<td class="text-end">$150</td>
								</tr>
								<tr>
									<td colspan="4">
										<table class="table-borderless w-100 table-fit">
											<tr>
												<td class="fw-bold">Sub Total :</td>
												<td class="text-end">$700.00</td>
											</tr>
											<tr>
												<td class="fw-bold">Discount :</td>
												<td class="text-end">-$50.00</td>
											</tr>
											<tr>
												<td class="fw-bold">Shipping :</td>
												<td class="text-end">0.00</td>
											</tr>
											<tr>
												<td class="fw-bold">Tax (5%) :</td>
												<td class="text-end">$5.00</td>
											</tr>
											<tr>
												<td class="fw-bold">Total Bill :</td>
												<td class="text-end">$655.00</td>
											</tr>
											<tr>
												<td class="fw-bold">Due :</td>
												<td class="text-end">$0.00</td>
											</tr>
											<tr>
												<td class="fw-bold">Total Payable :</td>
												<td class="text-end">$655.00</td>
											</tr>
										</table>
									</td>
								</tr>
							</tbody>
						</table>
						<div class="text-center invoice-bar">
							<div class="border-bottom border-dashed">
								<p>**VAT against this challan is payable through central registration. Thank you for your business!</p>
							</div>
							<a href="javascript:void(0);">
								<img src="{{asset('assets/img/barcode/barcode-03.jpg')}}" alt="Barcode">
							</a>
							<p class="text-dark fw-bold">Sale 31</p>
							<p>Thank You For Shopping With Us. Please Come Again</p>
							<a href="javascript:void(0);" class="btn btn-md btn-primary">Print Receipt</a>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Print Receipt -->

		<!-- Products -->
		<div class="modal fade modal-default pos-modal" id="products" aria-labelledby="products">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header d-flex align-items-center justify-content-between">
						<div class="d-flex align-items-center">
							<h5 class="me-4">Products</h5>
						</div>
						
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<div class="modal-body">
						<div class="card bg-light mb-3">
							<div class="card-body">
								<div class="d-flex align-items-center justify-content-between gap-3 flex-wrap mb-3">
									<span class="badge bg-dark fs-12">Order ID : #45698</span>
									<p class="fs-16">Number of Products : 02</p>
								</div>								
								<div class="product-wrap h-auto">
									<div class="product-list bg-white align-items-center justify-content-between">
										<div class="d-flex align-items-center product-info" data-bs-toggle="modal" data-bs-target="#products">
											<a href="javascript:void(0);" class="pro-img">
												<img src="{{asset('assets/img/products/pos-product-16.png')}}" alt="Products">
											</a>
											<div class="info">
												<h6><a href="javascript:void(0);">Red Nike Laser</a></h6>
												<p>Quantity : 04</p>
											</div>
										</div>
										<p class="text-teal fw-bold">$2000</p>
									</div>
									<div class="product-list bg-white align-items-center justify-content-between">
										<div class="d-flex align-items-center product-info" data-bs-toggle="modal" data-bs-target="#products">
											<a href="javascript:void(0);" class="pro-img">
												<img src="{{asset('assets/img/products/pos-product-17.png')}}" alt="Products">
											</a>
											<div class="info">
												<h6><a href="javascript:void(0);">Iphone 11S</a></h6>
												<p>Quantity : 04</p>
											</div>
										</div>
										<p class="text-teal fw-bold">$3000</p>
									</div>
								</div>
							</div>	
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Products -->
        <!-- Product details -->
		<div class="modal fade modal-default pos-modal" id="product-details" aria-labelledby="product-details">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header d-flex align-items-center justify-content-between">
						<div class="d-flex align-items-center">
							<h5 class="me-4">Product Details</h5>
						</div>
						
                        {{--<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">--}}
                        <button type="button" class="close" id="close-product-details">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<div class="modal-body">
						<div class="card bg-light mb-3">
							<div class="card-body">
								<div class="d-flex align-items-center justify-content-between gap-3 flex-wrap mb-3">
									<span class="badge bg-dark fs-12">Options</span>
									<p class="fs-16" id="options_count"></p>
								</div>								
								<div class="product-wrap h-auto" id="op-wrap">
								</div>
							</div>	
						</div>
                        <div class="card bg-light mb-3 fadeDiv">
							<div class="card-body">
								<div class="d-flex align-items-center justify-content-between gap-3 flex-wrap mb-3">
									<span class="badge bg-dark fs-12">Additions</span>
									<p class="fs-16" id="additions_count"></p>
								</div>	
                                {{--<div class="addition-title">op one</div>--}}							
								<div class="product-wrap h-auto addition-group" data-parent="op one" id="ad-wrap">
								</div>
                                {{--<div class="product-wrap h-auto addition-group" data-parent="op two">
                                    <div class="addition-title">op two</div>
									<div class="product-list product-dt-item bg-white align-items-center justify-content-between" data-name="op two ad one" data-image="{{asset('assets/img/products/pos-product-16.png')}}" data-detail="ad" data-parent="op two">
										<div class="d-flex align-items-center">
											<a href="javascript:void(0);" class="pro-img">
												<img src="{{asset('assets/img/products/pos-product-16.png')}}" alt="Products">
											</a>
											<div class="info">
												<h6><a href="javascript:void(0);">Red Nike Laser</a></h6>
												<p>Quantity : 04</p>
											</div>
										</div>
										<p class="text-teal fw-bold">$2000</p>
									</div>
									<div class="product-list product-dt-item bg-white align-items-center justify-content-between" data-name="op two ad two" data-image="{{asset('assets/img/products/pos-product-17.png')}}" data-detail="ad" data-parent="op two">
										<div class="d-flex align-items-center">
											<a href="javascript:void(0);" class="pro-img">
												<img src="{{asset('assets/img/products/pos-product-17.png')}}" alt="Products">
											</a>
											<div class="info">
												<h6><a href="javascript:void(0);">Iphone 11S</a></h6>
												<p>Quantity : 04</p>
											</div>
										</div>
										<p class="text-teal fw-bold">$3000</p>
									</div>
								</div>--}}
							</div>	
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Product details -->

        <!--wanted quantity of product-->
        <div class="modal fade" id="qty-pop" tabindex="-1" aria-labelledby="create"  aria-hidden="true">
			<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" >Quantity</h5>
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<form action="pos-2.html">
						<div class="modal-body pb-1">
							<div class="row">
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Quantity <span class="text-danger">*</span></label>
										<input type="text" name="qty" class="form-control">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer d-flex justify-content-end gap-2 flex-wrap">
							<button type="button" class="btn btn-md btn-secondary" data-bs-dismiss="modal">Cancel</button>
							<button type="submit" class="btn btn-md btn-primary">Submit</button>
						</div>
					</form>					
				</div>
			</div>
		</div>
        <!--/wanted qunatity of product-->

		<div class="modal fade" id="create" tabindex="-1" aria-labelledby="create"  aria-hidden="true">
			<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" >Create</h5>
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<form action="pos-2.html">
						<div class="modal-body pb-1">
							<div class="row">
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Customer Name <span class="text-danger">*</span></label>
										<input type="text" class="form-control">
									</div>
								</div>
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Phone <span class="text-danger">*</span></label>
										<input type="text" class="form-control">
									</div>
								</div>
								<div class="col-lg-12">
									<div class="mb-3">
										<label class="form-label">Email</label>
										<input type="email" class="form-control">
									</div>
								</div>
								<div class="col-lg-12">
									<div class="mb-3">
										<label class="form-label">Address</label>
										<input type="text" class="form-control">
									</div>
								</div>
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">City</label>
										<input type="text" class="form-control">
									</div>
								</div>
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Country</label>
										<input type="text" class="form-control">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer d-flex justify-content-end gap-2 flex-wrap">
							<button type="button" class="btn btn-md btn-secondary" data-bs-dismiss="modal">Cancel</button>
							<button type="submit" class="btn btn-md btn-primary">Submit</button>
						</div>
					</form>					
				</div>
			</div>
		</div>

		<!-- Hold -->
		<div class="modal fade modal-default pos-modal" id="hold-order" aria-labelledby="hold-order">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Hold order</h5>
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<form action="pos-2.html">
						<div class="modal-body">
							<div class="bg-light br-10 p-4 text-center mb-3">
								<h2 class="display-1">4500.00</h2>
							</div>
							<div class="mb-3">
								<label class="form-label">Order Reference <span class="text-danger">*</span></label>
								<input class="form-control" type="text" value="" placeholder="">
							</div>
							<p>The current order will be set on hold. You can retreive this order from the pending order button. Providing a reference to it might help you to identify the order more quickly.</p>
						</div>
						<div class="modal-footer d-flex justify-content-end gap-2">
							<button type="button" class="btn btn-md btn-secondary" data-bs-dismiss="modal">Cancel</button>
							<button type="submit" class="btn btn-md btn-primary">Confirm</button>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- /Hold -->

		<!-- Edit Product -->
		<div class="modal fade modal-default pos-modal" id="edit-product" aria-labelledby="edit-product">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Edit Product</h5>
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<form action="pos-2.html">
						<div class="modal-body pb-1">
							<div class="row">
								<div class="col-lg-12">
									<div class="mb-3">
										<label class="form-label">Product Name <span class="text-danger">*</span></label>
										<input type="text" class="form-control" value="Red Nike Laser Show" disabled>
									</div>
								</div>
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Product Price <span class="text-danger">*</span></label>
										<div class="input-icon-start position-relative">
											<span class="input-icon-addon text-gray-9">
												<i class="ti ti-currency-dollar"></i>
											</span>
											<input type="text" class="form-control" value="1800">
										</div>
									</div>
								</div>
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Tax Type <span class="text-danger">*</span></label>
										<select class="select">
											<option>Exclusive</option>
											<option>Inclusive</option>
										</select>
									</div>
								</div>
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Tax <span class="text-danger">*</span></label>
										<div class="input-icon-start position-relative">
											<span class="input-icon-addon text-gray-9">
												<i class="ti ti-percentage"></i>
											</span>
											<input type="text" class="form-control" value="15">
										</div>
									</div>
								</div>
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Discount Type <span class="text-danger">*</span></label>
										<select class="select">
											<option>Percentage</option>
											<option>Early payment discounts</option>
										</select>
									</div>
								</div>
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Discount <span class="text-danger">*</span></label>
										<input type="text" class="form-control" value="15">
									</div>
								</div>
								<div class="col-lg-6 col-sm-12 col-12">
									<div class="mb-3">
										<label class="form-label">Sale Unit <span class="text-danger">*</span></label>
										<select class="select">
											<option>Kilogram</option>
											<option>Grams</option>
										</select>
									</div>
								</div>
							</div>	
						</div>										
						<div class="modal-footer d-flex justify-content-end flex-wrap gap-2">
							<button type="button" class="btn btn-md btn-secondary" data-bs-dismiss="modal">Cancel</button>
						   <button type="submit" class="btn btn-md btn-primary">Submit</button>
					   </div>
					</form>
				</div>
			</div>
		</div>
		<!-- /Edit Product -->

		<!-- Delete Product -->
		<div class="modal fade modal-default" id="delete" aria-labelledby="payment-completed">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-body p-0">
						<div class="success-wrap text-center">
							<form action="pos-2.html">
								<div class="icon-success bg-danger-transparent text-danger mb-2">
									<i class="ti ti-trash"></i>
								</div>
								<h3 class="mb-2">Are you Sure!</h3>
								<p class="fs-16 mb-3">The current order will be deleted as no payment has been made so far.
								</p>
								<div class="d-flex align-items-center justify-content-center gap-2 flex-wrap">
									<button type="button" class="btn btn-md btn-secondary" data-bs-dismiss="modal">No, Cancel</button>
									<button type="submit" class="btn btn-md btn-primary">Yes, Delete</button>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Delete Product -->

		<!-- Reset -->
		<div class="modal fade modal-default" id="reset" aria-labelledby="payment-completed">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-body p-0">
						<div class="success-wrap text-center">
							<form action="pos-2.html">
								<div class="icon-success bg-purple-transparent text-purple mb-2">
									<i class="ti ti-transition-top"></i>
								</div>
								<h3 class="mb-2">Confirm Your Action</h3>
								<p class="fs-16 mb-3">The current order will be cleared. But not deleted if it's persistent. Would you like to proceed ?</p>
								<div class="d-flex align-items-center justify-content-center gap-2 flex-wrap">
									<button type="button" class="btn btn-md btn-secondary" data-bs-dismiss="modal">No, Cancel</button>
									<button type="submit" class="btn btn-md btn-primary">Yes, Proceed</button>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Reset -->

		<!-- Recent Transactions -->
		<div class="modal fade pos-modal" id="recents" tabindex="-1"    aria-hidden="true">
			<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						 <h5 class="modal-title" >Recent Transactions</h5>
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<div class="modal-body">
						<div class="tabs-sets">
							<ul class="nav nav-tabs" id="myTab" role="tablist">
								<li class="nav-item" role="presentation">
								  <button class="nav-link active" id="purchase-tab" data-bs-toggle="tab" data-bs-target="#purchase" type="button"   aria-controls="purchase" aria-selected="true" role="tab">Purchase</button>
								</li>
								<li class="nav-item" role="presentation">
								  <button class="nav-link" id="payment-tab" data-bs-toggle="tab" data-bs-target="#payment" type="button"   aria-controls="payment" aria-selected="false" role="tab">Payment</button>
								</li>
								<li class="nav-item" role="presentation">
								  <button class="nav-link" id="return-tab" data-bs-toggle="tab" data-bs-target="#return" type="button"   aria-controls="return" aria-selected="false" role="tab">Return</button>
								</li>
							  </ul>
							  <div class="tab-content" >
								<div class="tab-pane fade show active" id="purchase" role="tabpanel" aria-labelledby="purchase-tab">
									<div class="card mb-0">
										<div class="card-header d-flex align-items-center justify-content-between flex-wrap row-gap-3">
											<div class="search-set">
												<div class="search-input">
													<span class="btn-searchset"><i class="ti ti-search fs-14 feather-search"></i></span>
												</div>
											</div>
											<ul class="table-top-head">
												<li>
													<a data-bs-toggle="tooltip" data-bs-placement="top" title="Pdf"><img src="{{asset('assets/img/icons/pdf.svg')}}" alt="img"></a>
												</li>
												<li>
													<a data-bs-toggle="tooltip" data-bs-placement="top" title="Excel"><img src="{{asset('assets/img/icons/excel.svg')}}" alt="img"></a>
												</li>
												<li>
													<a data-bs-toggle="tooltip" data-bs-placement="top" title="Print"><i class="ti ti-printer"></i></a>
												</li>
											</ul>
										</div>
										<div class="card-body">
											<div class="table-responsive">
												<table class="table datatable border">
													<thead class="thead-light">
														<tr>
															<th class="no-sort">
																<label class="checkboxs">
																	<input type="checkbox" class="select-all">
																	<span class="checkmarks"></span>
																</label>
															</th>
															<th>Customer</th>
															<th>Reference</th>
															<th>Date</th>
															<th>Amount	</th>
															<th class="no-sort">Action</th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-27.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Carl Evans</a>
																</div>
															</td>
															<td>INV/SL0101</td>
															<td>24 Dec 2024</td>
															<td>$1000</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-02.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Minerva Rameriz</a>
																</div>
															</td>
															<td>INV/SL0102</td>
															<td>10 Dec 2024</td>
															<td>$1500</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-05.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Robert Lamon</a>
																</div>
															</td>
															<td>INV/SL0103</td>
															<td>27 Nov 2024</td>
															<td>$1500</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-22.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Patricia Lewis</a>
																</div>
															</td>
															<td>INV/SL0104</td>
															<td>18 Nov 2024</td>
															<td>$2000</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-03.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Mark Joslyn</a>
																</div>
															</td>
															<td>INV/SL0105</td>
															<td>06 Nov 2024</td>
															<td>$800</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-12.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Marsha Betts</a>
																</div>
															</td>
															<td>INV/SL0106</td>
															<td>25 Oct 2024</td>
															<td>$750</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-06.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Daniel Jude</a>
																</div>
															</td>
															<td>INV/SL0107</td>
															<td>14 Oct 2024</td>
															<td>$1300</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
								<div class="tab-pane fade" id="payment" role="tabpanel" >
									<div class="card mb-0">
										<div class="card-header d-flex align-items-center justify-content-between flex-wrap row-gap-3">
											<div class="search-set">
												<div class="search-input">
													<span class="btn-searchset"><i class="ti ti-search fs-14 feather-search"></i></span>
												</div>
											</div>
											<ul class="table-top-head">
												<li>
													<a data-bs-toggle="tooltip" data-bs-placement="top" title="Pdf"><img src="{{asset('assets/img/icons/pdf.svg')}}" alt="img"></a>
												</li>
												<li>
													<a data-bs-toggle="tooltip" data-bs-placement="top" title="Excel"><img src="{{asset('assets/img/icons/excel.svg')}}" alt="img"></a>
												</li>
												<li>
													<a data-bs-toggle="tooltip" data-bs-placement="top" title="Print"><i class="ti ti-printer"></i></a>
												</li>
											</ul>
										</div>
										<div class="card-body">
											<div class="table-responsive">
												<table class="table datatable border">
													<thead class="thead-light">
														<tr>
															<th class="no-sort">
																<label class="checkboxs">
																	<input type="checkbox" class="select-all">
																	<span class="checkmarks"></span>
																</label>
															</th>
															<th>Customer</th>
															<th>Reference</th>
															<th>Date</th>
															<th>Amount	</th>
															<th class="no-sort">Action</th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-27.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Carl Evans</a>
																</div>
															</td>
															<td>INV/SL0101</td>
															<td>24 Dec 2024</td>
															<td>$1000</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-02.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Minerva Rameriz</a>
																</div>
															</td>
															<td>INV/SL0102</td>
															<td>10 Dec 2024</td>
															<td>$1500</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-05.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Robert Lamon</a>
																</div>
															</td>
															<td>INV/SL0103</td>
															<td>27 Nov 2024</td>
															<td>$1500</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-22.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Patricia Lewis</a>
																</div>
															</td>
															<td>INV/SL0104</td>
															<td>18 Nov 2024</td>
															<td>$2000</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-03.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Mark Joslyn</a>
																</div>
															</td>
															<td>INV/SL0105</td>
															<td>06 Nov 2024</td>
															<td>$800</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-12.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Marsha Betts</a>
																</div>
															</td>
															<td>INV/SL0106</td>
															<td>25 Oct 2024</td>
															<td>$750</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-06.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Daniel Jude</a>
																</div>
															</td>
															<td>INV/SL0107</td>
															<td>14 Oct 2024</td>
															<td>$1300</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
								<div class="tab-pane fade" id="return" role="tabpanel" >
									<div class="card mb-0">
										<div class="card-header d-flex align-items-center justify-content-between flex-wrap row-gap-3">
											<div class="search-set">
												<div class="search-input">
													<span class="btn-searchset"><i class="ti ti-search fs-14 feather-search"></i></span>
												</div>
											</div>
											<ul class="table-top-head">
												<li>
													<a data-bs-toggle="tooltip" data-bs-placement="top" title="Pdf"><img src="{{asset('assets/img/icons/pdf.svg')}}" alt="img"></a>
												</li>
												<li>
													<a data-bs-toggle="tooltip" data-bs-placement="top" title="Excel"><img src="{{asset('assets/img/icons/excel.svg')}}" alt="img"></a>
												</li>
												<li>
													<a data-bs-toggle="tooltip" data-bs-placement="top" title="Print"><i class="ti ti-printer"></i></a>
												</li>
											</ul>
										</div>
										<div class="card-body">
											<div class=" table-responsive">
												<table class="table datatable border">
													<thead class="thead-light">
														<tr>
															<th class="no-sort">
																<label class="checkboxs">
																	<input type="checkbox" class="select-all">
																	<span class="checkmarks"></span>
																</label>
															</th>
															<th>Customer</th>
															<th>Reference</th>
															<th>Date</th>
															<th>Amount	</th>
															<th class="no-sort">Action</th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-27.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Carl Evans</a>
																</div>
															</td>
															<td>INV/SL0101</td>
															<td>24 Dec 2024</td>
															<td>$1000</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-02.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Minerva Rameriz</a>
																</div>
															</td>
															<td>INV/SL0102</td>
															<td>10 Dec 2024</td>
															<td>$1500</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-05.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Robert Lamon</a>
																</div>
															</td>
															<td>INV/SL0103</td>
															<td>27 Nov 2024</td>
															<td>$1500</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-22.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Patricia Lewis</a>
																</div>
															</td>
															<td>INV/SL0104</td>
															<td>18 Nov 2024</td>
															<td>$2000</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-03.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Mark Joslyn</a>
																</div>
															</td>
															<td>INV/SL0105</td>
															<td>06 Nov 2024</td>
															<td>$800</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-12.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Marsha Betts</a>
																</div>
															</td>
															<td>INV/SL0106</td>
															<td>25 Oct 2024</td>
															<td>$750</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
														<tr>
															<td>
																<label class="checkboxs">
																	<input type="checkbox">
																	<span class="checkmarks"></span>
																</label>
															</td>
															<td>
																<div class="d-flex align-items-center">
																	<a href="javascript:void(0);" class="avatar avatar-md me-2">
																		<img src="{{asset('assets/img/users/user-06.jpg')}}" alt="product">
																	</a>
																	<a href="javascript:void(0);">Daniel Jude</a>
																</div>
															</td>
															<td>INV/SL0107</td>
															<td>14 Oct 2024</td>
															<td>$1300</td>
															<td class="action-table-data">
																<div class="edit-delete-action">
																	<a class="me-2 edit-icon p-2" href="javascript:void(0);"><i data-feather="eye" class="feather-eye"></i></a>
																	<a class="me-2 p-2" href="javascript:void(0);"><i data-feather="edit" class="feather-edit"></i></a>
																	<a class="p-2" href="javascript:void(0);"><i data-feather="trash-2" class="feather-trash-2"></i></a>
																</div>
															</td>
														</tr>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>	
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Recent Transactions -->

		<!-- Orders -->
		<div class="modal fade pos-modal" id="orders" tabindex="-1"  aria-hidden="true">
			<div class="modal-dialog modal-md modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						 <h5 class="modal-title" >Orders</h5>
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<div class="modal-body">
						<div class="tabs-sets">
							<ul class="nav nav-tabs" id="myTabs" role="tablist">
								<li class="nav-item" role="presentation">
								  <button class="nav-link active" id="onhold-tab" data-bs-toggle="tab" data-bs-target="#onhold" type="button"   aria-controls="onhold" aria-selected="true" role="tab">Onhold</button>
								</li>
								<li class="nav-item" role="presentation">
								  <button class="nav-link" id="unpaid-tab" data-bs-toggle="tab" data-bs-target="#unpaid" type="button"   aria-controls="unpaid" aria-selected="false" role="tab">Unpaid</button>
								</li>
								<li class="nav-item" role="presentation">
								  <button class="nav-link" id="paid-tab" data-bs-toggle="tab" data-bs-target="#paid" type="button"   aria-controls="paid" aria-selected="false" role="tab">Paid</button>
								</li>
							  </ul>
							  <div class="tab-content" >
								<div class="tab-pane fade show active" id="onhold" role="tabpanel" aria-labelledby="onhold-tab">
									<div class="input-icon-start pos-search position-relative mb-3">
										<span class="input-icon-addon">
											<i class="ti ti-search"></i>
										</span>
										<input type="text" class="form-control" placeholder="Search Product">
									</div>
									<div class="order-body">
										<div class="card bg-light mb-3">
											<div class="card-body">
												<span class="badge bg-dark fs-12 mb-2">Order ID : #45698</span>
												<div class="row g-3">
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Cashier :</span> admin</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Total :</span> $900</p>
													</div>
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Customer :</span>  Botsford</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Date :</span> 24 Dec 2024 13:39:11</p>
													</div>
												</div>
												<div class="bg-info-transparent p-1 rounded text-center my-3">
													<p class="text-info fw-medium">Customer need to recheck the product once</p>
												</div>
												<div class="d-flex align-items-center justify-content-center flex-wrap gap-2">
													<a href="javascript:void(0);" class="btn btn-md btn-orange">Open Order</a>
													<a href="javascript:void(0);" class="btn btn-md btn-teal" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#products">View Products</a>
													<a href="javascript:void(0);" class="btn btn-md btn-indigo">Print</a>
												</div>
											</div>	
										</div>
										<div class="card bg-light mb-0">
											<div class="card-body">
												<span class="badge bg-dark fs-12 mb-2">Order ID : #666659</span>
												<div class="mb-3">
													<div class="row g-3">
														<div class="col-md-6">
															<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Cashier :</span> admin</p>
															<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Total :</span> $900</p>
														</div>
														<div class="col-md-6">
															<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Customer :</span>  Botsford</p>
															<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Date :</span> 24 Dec 2024 13:39:11</p>
														</div>
													</div>
												</div>
											</div>	
										</div>
									</div>
								</div>
								<div class="tab-pane fade" id="unpaid" role="tabpanel" >
									<div class="input-icon-start pos-search position-relative mb-3">
										<span class="input-icon-addon">
											<i class="ti ti-search"></i>
										</span>
										<input type="text" class="form-control" placeholder="Search Product">
									</div>
									<div class="order-body">
										<div class="card bg-light mb-3">
											<div class="card-body">
												<span class="badge bg-dark fs-12 mb-2">Order ID : #45698</span>
												<div class="row g-3">
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Cashier :</span> admin</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Total :</span> $900</p>
													</div>
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Customer :</span>  Anastasia</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Date :</span> 24 Dec 2024 13:39:11</p>
													</div>
												</div>
												<div class="bg-info-transparent p-1 rounded text-center my-3">
													<p class="text-info fw-medium">Customer need to recheck the product once</p>
												</div>
												<div class="d-flex align-items-center justify-content-center flex-wrap gap-2">
													<a href="javascript:void(0);" class="btn btn-md btn-orange">Open Order</a>
													<a href="javascript:void(0);" class="btn btn-md btn-teal" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#products">View Products</a>
													<a href="javascript:void(0);" class="btn btn-md btn-indigo">Print</a>
												</div>
											</div>	
										</div>
										<div class="card bg-light mb-0">
											<div class="card-body">
												<span class="badge bg-dark fs-12 mb-2">Order ID : #666659</span>
												<div class="row g-3">
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Cashier :</span> admin</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Total :</span> $900</p>
													</div>
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Customer :</span>  Lucia</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Date :</span> 24 Dec 2024 13:39:11</p>
													</div>
												</div>
											</div>	
										</div>
									</div>
								</div>
								<div class="tab-pane fade" id="paid" role="tabpanel" >
									<div class="input-icon-start pos-search position-relative mb-3">
										<span class="input-icon-addon">
											<i class="ti ti-search"></i>
										</span>
										<input type="text" class="form-control" placeholder="Search Product">
									</div>
									<div class="order-body">
										<div class="card bg-light mb-3">
											<div class="card-body">
												<span class="badge bg-dark fs-12 mb-2">Order ID : #45698</span>
												<div class="row g-3">
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Cashier :</span> admin</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Total :</span> $1000</p>
													</div>
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Customer :</span>  Hugo</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Date :</span> 24 Dec 2024 13:39:11</p>
													</div>
												</div>
												<div class="bg-info-transparent p-1 rounded text-center my-3">
													<p class="text-info fw-medium">Customer need to recheck the product once</p>
												</div>
												<div class="d-flex align-items-center justify-content-center flex-wrap gap-2">
													<a href="javascript:void(0);" class="btn btn-md btn-orange">Open Order</a>
													<a href="javascript:void(0);" class="btn btn-md btn-teal" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#products">View Products</a>
													<a href="javascript:void(0);" class="btn btn-md btn-indigo">Print</a>
												</div>
											</div>	
										</div>
										<div class="card bg-light mb-0">
											<div class="card-body">
												<span class="badge bg-dark fs-12 mb-2">Order ID : #666659</span>
												<div class="row g-3">
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Cashier :</span> admin</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Total :</span> $9100</p>
													</div>
													<div class="col-md-6">
														<p class="fs-15 mb-1"><span class="fs-14 fw-bold text-gray-9">Customer :</span>  Antonio</p>
														<p class="fs-15"><span class="fs-14 fw-bold text-gray-9">Date :</span> 23 Dec 2024 13:39:11</p>
													</div>
												</div>
											</div>	
										</div>
									</div>
								</div>
							</div>	
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Orders -->

		<!-- Scan -->
		<div class="modal fade modal-default" id="scan-payment">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-body p-0">
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
						<div class="success-wrap scan-wrap text-center">
							<h5><span class="text-gray-6">Amount to Pay :</span> $150</h5>
							<div class="scan-img">
								<img src="{{asset('assets/img/icons/scan-img.svg')}}" alt="img">
							</div>
							<p class="mb-3">Scan your Phone or UPI App to Complete the payment</p>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Scan -->

		<!-- Payment Cash -->
		<div class="modal fade modal-default" id="payment-cash">
			<div class="modal-dialog modal-dialog-centered modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Finalize Sale</h5>
					   <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						   <span aria-hidden="true">×</span>
					   </button>
				   </div>
				   <form action="pos-2.html">
						<div class="modal-body pb-1">
							<div class="row">
								<div class="col-md-4">
									<div class="mb-3">
										<label class="form-label">Received Amount <span class="text-danger">*</span></label>
										<div class="input-icon-start position-relative">
											<span class="input-icon-addon text-gray-9">
												<i class="ti ti-currency-dollar"></i>
											</span>
											<input type="text" class="form-control" value="1800">
										</div>
									</div>
								</div>
								<div class="col-md-4">
									<div class="mb-3">
										<label class="form-label">Paying Amount <span class="text-danger">*</span></label>
										<div class="input-icon-start position-relative">
											<span class="input-icon-addon text-gray-9">
												<i class="ti ti-currency-dollar"></i>
											</span>
											<input type="text" class="form-control" value="1800">
										</div>
									</div>
								</div>
								<div class="col-md-4">
									<div class="change-item mb-3">
										<label class="form-label">Change</label>
										<div class="input-icon-start position-relative">
											<span class="input-icon-addon text-gray-9">
												<i class="ti ti-currency-dollar"></i>
											</span>
											<input type="text" class="form-control" value="0.00">
										</div>
									</div>
									<div class="point-item mb-3">
										<label class="form-label">Balance Point</label>
										<input type="text" class="form-control" value="200">
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Payment Type <span class="text-danger">*</span></label>
										<select class="select select-payment">
											<option value="credit">Credit Card</option>
											<option value="cash" selected>Cash</option>
											<option value="cheque">Cheque</option>
											<option value="deposit">Deposit</option>
											<option value="points">Points</option>
										</select>
									</div>
									<div class="quick-cash payment-content bg-light  mb-3">
										<div class="d-flex align-items-center flex-wra gap-4">
											<h5 class="text-nowrap">Quick Cash</h5>
											<div class="d-flex align-items-center flex-wrap gap-3">
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash21" checked>
													<label class="btn btn-white" for="cash21">10</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash22">
													<label class="btn btn-white" for="cash22">20</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash23">
													<label class="btn btn-white" for="cash23">50</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash24">
													<label class="btn btn-white" for="cash24">100</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash25">
													<label class="btn btn-white" for="cash25">500</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash26">
													<label class="btn btn-white" for="cash26">1000</label>
												</div>
											</div>
										</div>
									</div>
									<div class="point-wrap payment-content mb-3">
										<div class=" bg-success-transparent d-flex align-items-center justify-content-between flex-wrap p-2 gap-2 br-5">
											<h6 class="fs-14 fw-bold text-success">You have 2000 Points to Use</h6>
											<a href="javascript:void(0);" class="btn btn-dark btn-md">Use for this Purchase</a>
										</div>
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Payment Receiver</label>
										<input type="text" class="form-control">
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Payment Note</label>
										<textarea class="form-control" rows="3" placeholder="Type your message"></textarea>
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Sale Note</label>
										<textarea class="form-control" rows="3" placeholder="Type your message"></textarea>
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Staff Note</label>
										<textarea class="form-control" rows="3" placeholder="Type your message"></textarea>
									</div>
								</div>
							</div>							
						</div>
						<div class="modal-footer d-flex justify-content-end flex-wrap gap-2">
							<button type="button" class="btn btn-md btn-secondary" data-bs-dismiss="modal">Cancel</button>
							<button type="submit" class="btn btn-md btn-primary">Submit</button>
						</div>
				   </form>
				</div>
			</div>
		</div>
		<!-- /Payment Cash  -->

		<!-- Payment Card  -->
		<div class="modal fade modal-default" id="payment-card">
			<div class="modal-dialog modal-dialog-centered modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Finalize Sale</h5>
					   <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						   <span aria-hidden="true">×</span>
					   </button>
				   </div>
				   <form action="pos-2.html">
						<div class="modal-body pb-1">
							<div class="row">
								<div class="col-md-4">
									<div class="mb-3">
										<label class="form-label">Received Amount <span class="text-danger">*</span></label>
										<div class="input-icon-start position-relative">
											<span class="input-icon-addon text-gray-9">
												<i class="ti ti-currency-dollar"></i>
											</span>
											<input type="text" class="form-control" value="1800">
										</div>
									</div>
								</div>
								<div class="col-md-4">
									<div class="mb-3">
										<label class="form-label">Paying Amount <span class="text-danger">*</span></label>
										<div class="input-icon-start position-relative">
											<span class="input-icon-addon text-gray-9">
												<i class="ti ti-currency-dollar"></i>
											</span>
											<input type="text" class="form-control" value="1800">
										</div>
									</div>
								</div>
								<div class="col-md-4">
									<div class="change-item mb-3">
										<label class="form-label">Change</label>
										<div class="input-icon-start position-relative">
											<span class="input-icon-addon text-gray-9">
												<i class="ti ti-currency-dollar"></i>
											</span>
											<input type="text" class="form-control" value="0.00">
										</div>
									</div>
									<div class="point-item mb-3">
										<label class="form-label">Balance Point</label>
										<input type="text" class="form-control" value="200">
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Payment Type <span class="text-danger">*</span></label>
										<select class="select select-payment">
											<option value="credit" selected>Credit Card</option>
											<option value="cash">Cash</option>
											<option value="cheque">Cheque</option>
											<option value="deposit">Deposit</option>
											<option value="points">Points</option>
										</select>
									</div>
									<div class="quick-cash payment-content bg-light  mb-3">
										<div class="d-flex align-items-center flex-wra gap-4">
											<h5 class="text-nowrap">Quick Cash</h5>
											<div class="d-flex align-items-center flex-wrap gap-3">
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash11" checked>
													<label class="btn btn-white" for="cash11">10</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash12">
													<label class="btn btn-white" for="cash12">20</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash13">
													<label class="btn btn-white" for="cash13">50</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash14">
													<label class="btn btn-white" for="cash14">100</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash15">
													<label class="btn btn-white" for="cash15">500</label>
												</div>
												<div class="form-check">
													<input type="radio" class="btn-check" name="cash" id="cash16">
													<label class="btn btn-white" for="cash16">1000</label>
												</div>
											</div>
										</div>
									</div>
									<div class="point-wrap payment-content mb-3">
										<div class=" bg-success-transparent d-flex align-items-center justify-content-between flex-wrap p-2 gap-2 br-5">
											<h6 class="fs-14 fw-bold text-success">You have 2000 Points to Use</h6>
											<a href="javascript:void(0);" class="btn btn-dark btn-md">Use for this Purchase</a>
										</div>
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Payment Receiver</label>
										<input type="text" class="form-control">
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Payment Note</label>
										<textarea class="form-control" rows="3" placeholder="Type your message"></textarea>
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Sale Note</label>
										<textarea class="form-control" rows="3" placeholder="Type your message"></textarea>
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">Staff Note</label>
										<textarea class="form-control" rows="3" placeholder="Type your message"></textarea>
									</div>
								</div>
							</div>							
						</div>
						<div class="modal-footer d-flex justify-content-end flex-wrap gap-2">
							<button type="button" class="btn btn-md btn-secondary" data-bs-dismiss="modal">Cancel</button>
							<button type="submit" class="btn btn-md btn-primary">Submit</button>
						</div>
				   </form>
				</div>
			</div>
		</div>
		<!-- /Payment Card  -->

		 <!-- Calculator -->
		<div class="modal fade pos-modal" id="calculator" tabindex="-1"  aria-hidden="true">
			<div class="modal-dialog modal-md modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body p-0">
						<div class="calculator-wrap">
							<div class="p-3">
								<div class="d-flex align-items-center">
									<h3>Calculator</h3>
									<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
										<span aria-hidden="true">×</span>
									</button>
								</div>							
								<div>
									<input class="input" type="text" placeholder="0" readonly>
								</div>
							</div>
							<div class="calculator-body d-flex justify-content-between">
								<div class="text-center">
									<button class="btn btn-clear" onclick="clr()">C</button>
									<button class="btn btn-number" onclick="dis('7')">7</button>
									<button class="btn btn-number" onclick="dis('4')">4</button>
									<button class="btn btn-number" onclick="dis('1')">1</button>
									<button class="btn btn-number" onclick="dis(',')">,</button>
								</div>
								<div class="text-center">
									<button class="btn btn-expression" onclick="dis('/')">÷</button>
									<button class="btn btn-number" onclick="dis('8')">8</button>
									<button class="btn btn-number" onclick="dis('5')">5</button>
									<button class="btn btn-number" onclick="dis('2')">2</button>
									<button class="btn btn-number" onclick="dis('00')">00</button>									
								</div>
								<div class="text-center">
									<button class="btn btn-expression" onclick="dis('%')">%</button>
									<button class="btn btn-number" onclick="dis('9')">9</button>
									<button class="btn btn-number" onclick="dis('6')">6</button>
									<button class="btn btn-number" onclick="dis('3')">3</button>
									<button class="btn btn-number" onclick="dis('.')">.</button>									
								</div>
								<div class="text-center">
									<button class="btn btn-clear" onclick="back()"><i class="ti ti-backspace"></i></button>
									<button class="btn btn-expression" onclick="dis('*')">x</button>
									<button class="btn btn-expression" onclick="dis('-')">-</button>
									<button class="btn btn-expression" onclick="dis('+')">+</button>
									<button class="btn btn-clear" onclick="solve()">=</button>									
								</div>
							</div>							
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Calculator -->

		<!-- Cash Register Details -->
		<div class="modal fade pos-modal" id="cash-register" tabindex="-1"  aria-hidden="true">
			<div class="modal-dialog modal-md modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						 <h5 class="modal-title">Cash Register Details</h5>
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<div class="modal-body">
						<div class="table-responsive">
							<table class="table table-striped border">
								<tr>
									<td>Cash in Hand</td>
									<td class="text-gray-9 fw-medium text-end">$45689</td>
								</tr>
								<tr>
									<td>Total Sale Amount</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Total Payment</td>
									<td class="text-gray-9 fw-medium text-end">$566867.97</td>
								</tr>
								<tr>
									<td>Cash Payment</td>
									<td class="text-gray-9 fw-medium text-end">$3355.84</td>
								</tr>
								<tr>
									<td>Total Sale Return</td>
									<td class="text-gray-9 fw-medium text-end">$1959</td>
								</tr>
								<tr>
									<td>Total Expense</td>
									<td class="text-gray-9 fw-medium text-end">$0</td>
								</tr>
								<tr>
									<td class="text-gray-9 fw-bold bg-secondary-transparent">Total Cash</td>
									<td class="text-gray-9 fw-bold text-end bg-secondary-transparent">$587130.97</td>
								</tr>
							</table>
						</div>
					</div>
					<div class="modal-footer d-flex justify-content-end gap-2 flex-wrap">
						<button type="button" class="btn btn-md btn-primary" data-bs-dismiss="modal">Cancel</button>
					</div>
				</div>
			</div>
		</div>
		<!-- /Cash Register Details -->

		<!-- Today's Sale -->
		<div class="modal fade pos-modal" id="today-sale" tabindex="-1"  aria-hidden="true">
			<div class="modal-dialog modal-md modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						 <h5 class="modal-title">Today's Sale</h5>
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<div class="modal-body">
						<div class="table-responsive">
							<table class="table table-striped border">
								<tr>
									<td>Total Sale Amount</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Cash Payment</td>
									<td class="text-gray-9 fw-medium text-end">$3355.84</td>
								</tr>
								<tr>
									<td>Credit Card Payment</td>
									<td class="text-gray-9 fw-medium text-end">$1959</td>
								</tr>
								<tr>
									<td>Cheque Payment:</td>
									<td class="text-gray-9 fw-medium text-end">$0</td>
								</tr>
								<tr>
									<td>Deposit Payment</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Points Payment</td>
									<td class="text-gray-9 fw-medium text-end">$3355.84</td>
								</tr>
								<tr>
									<td>Gift Card Payment</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Scan & Pay</td>
									<td class="text-gray-9 fw-medium text-end">$3355.84</td>
								</tr>
								<tr>
									<td>Pay Later</td>
									<td class="text-gray-9 fw-medium text-end">$3355.84</td>
								</tr>
								<tr>
									<td>Total Payment</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Total Sale Return</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Total Expense:</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td class="text-gray-9 fw-bold bg-secondary-transparent">Total Cash</td>
									<td class="text-gray-9 fw-bold text-end bg-secondary-transparent">$587130.97</td>
								</tr>
							</table>
						</div>
					</div>
					<div class="modal-footer d-flex justify-content-end gap-2 flex-wrap">
						<button type="button" class="btn btn-md btn-primary" data-bs-dismiss="modal">Cancel</button>
					</div>
				</div>
			</div>
		</div>
		<!-- /Today's Sale -->

		<!-- Today's Profit -->
		<div class="modal fade pos-modal" id="today-profit" tabindex="-1"  aria-hidden="true">
			<div class="modal-dialog modal-md modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						 <h5 class="modal-title">Today's Profit</h5>
						<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">×</span>
						</button>
					</div>
					<div class="modal-body">
						<div class="row justify-content-center g-3 mb-3">
							<div class="col-lg-4 col-md-6 d-flex">
								<div class="border border-success bg-success-transparent br-8 p-3 flex-fill">
									<p class="fs-16 text-gray-9 mb-1">Total Sale</p>
									<h3 class="text-success">$89954</h3>
								</div>
							</div>
							<div class="col-lg-4 col-md-6 d-flex">
								<div class="border border-danger bg-danger-transparent br-8 p-3 flex-fill">
									<p class="fs-16 text-gray-9 mb-1">Expense</p>
									<h3 class="text-danger">$89954</h3>
								</div>
							</div>
							<div class="col-lg-4 col-md-6 d-flex">
								<div class="border border-info bg-info-transparent br-8 p-3 flex-fill">
									<p class="fs-16 text-gray-9 mb-1">Total Profit	</p>
									<h3 class="text-info">$2145</h3>
								</div>
							</div>
						</div>
						<div class="table-responsive">
							<table class="table table-striped border">
								<tr>
									<td>Product Revenue</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Product Cost</td>
									<td class="text-gray-9 fw-medium text-end">$3355.84</td>
								</tr>
								<tr>
									<td>Expense</td>
									<td class="text-gray-9 fw-medium text-end">$1959</td>
								</tr>
								<tr>
									<td>Total Stock Adjustment</td>
									<td class="text-gray-9 fw-medium text-end">$0</td>
								</tr>
								<tr>
									<td>Deposit Payment</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Total Purchase Shipping Cost</td>
									<td class="text-gray-9 fw-medium text-end">$3355.84</td>
								</tr>
								<tr>
									<td>Total Sell Discount</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Total Sell Return</td>
									<td class="text-gray-9 fw-medium text-end">$3355.84</td>
								</tr>
								<tr>
									<td>Closing Stock</td>
									<td class="text-gray-9 fw-medium text-end">$3355.84</td>
								</tr>
								<tr>
									<td>Total Sales</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Total Sale Return</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td>Total Expense</td>
									<td class="text-gray-9 fw-medium text-end">$565597.88</td>
								</tr>
								<tr>
									<td class="text-gray-9 fw-bold bg-secondary-transparent">Total Cash</td>
									<td class="text-gray-9 fw-bold text-end bg-secondary-transparent">$587130.97</td>
								</tr>
							</table>
						</div>
					</div>
					<div class="modal-footer d-flex justify-content-end gap-2 flex-wrap">
						<button type="button" class="btn btn-md btn-primary" data-bs-dismiss="modal">Cancel</button>
					</div>
				</div>
			</div>
		</div>
		<!-- /Today's Profit -->
		
		<!-- jQuery -->
		<script src="{{asset('assets/js/jquery-3.7.1.min.js')}}"></script>

		<!-- Feather Icon JS -->
		<script src="{{asset('assets/js/feather.min.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/js/jquery.slimscroll.min.js')}}"></script>
		
		<!-- Bootstrap Core JS -->
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>

		<!-- Datatable JS -->
		<script src="{{asset('assets/js/jquery.dataTables.min.js')}}"></script>
		<script src="{{asset('assets/js/dataTables.bootstrap5.min.js')}}"></script>

		<!-- Daterangepikcer JS -->
		<script src="{{asset('assets/js/moment.min.js')}}"></script>
		<script src="{{asset('assets/plugins/daterangepicker/daterangepicker.js')}}"></script>

		<!-- Owl JS -->
		<script src="{{asset('assets/plugins/owlcarousel/owl.carousel.min.js')}}"></script>

		<!-- Select2 JS -->
		<script src="{{asset('assets/plugins/select2/js/select2.min.js')}}"></script>

		<!-- Sticky-sidebar -->
		<script src="{{asset('assets/plugins/theia-sticky-sidebar/ResizeSensor.js')}}"></script>
		<script src="{{asset('assets/plugins/theia-sticky-sidebar/theia-sticky-sidebar.js')}}"></script>

		<!-- Color Picker JS -->
		<script src="{{asset('assets/plugins/@simonwep/pickr/pickr.es5.min.js')}}"></script>
		
		<!-- Custom JS -->
		<script src="{{asset('assets/js/theme-colorpicker.js')}}"></script>
		<script src="{{asset('assets/js/calculator.js')}}"></script>
		<script src="{{asset('assets/js/script.js')}}"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

	
	</body>
</html>