<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class HomeController extends Controller
{
    //home
    public function index(){
        $store_id = env('STORE_ID');
        $forGetProducts = ['store_id' => $store_id, 'offset' => 30];
        $cpi_token = env('NEWPOS_TOKEN');
        $cpi_url = env('CPI_URL');
        $products_url = $cpi_url.'store_products';
        $getProductsResponse = Http::withHeaders(['fcmToken' => 'abc123','cpiToken' => $cpi_token,'platform' =>'new_pos', 'Content-Type' => 'application/json','Accept-Language' => 'en'])->post($products_url, $forGetProducts);
        //return $getProductsResponse; 
        $forGetProductsCategories = ['store_id' => $store_id];
        $products_categories_url = $cpi_url.'store_products_categories';
        $getProductsCategoriesResponse = Http::withHeaders(['fcmToken' => 'abc123','cpiToken' => $cpi_token,'platform' =>'new_pos', 'Content-Type' => 'application/json','Accept-Language' => 'en'])->post($products_categories_url, $forGetProductsCategories);
        //return $getProductsCategoriesResponse;
        if($getProductsResponse['code'] == 201 || $getProductsCategoriesResponse['code'] == 201){
            return 'login page';
       }
       //return $getProductsCategoriesResponse;
       $products = $getProductsResponse['data'];
       $store_details = $getProductsResponse['store_details'];
       $productsCategories = $getProductsCategoriesResponse['data'];
       //return $productsCategories;
        return view('home', ['products' => $products, 'store_details' => $store_details, 'productsCategories' => $productsCategories]);
    }

    public function product_details(Request $request){
        $product_id = $request->product_id;
        $forGetProducts = ['product_id' => $product_id];
        $cpi_token = env('NEWPOS_TOKEN');
        $cpi_url = env('CPI_URL');
        $product_detail_url = $cpi_url.'product_options_additions';
        $getProductDetailResponse = Http::withHeaders(['fcmToken' => 'abc123','cpiToken' => $cpi_token,'platform' =>'new_pos', 'Content-Type' => 'application/json','Accept-Language' => 'en'])->post($product_detail_url, $forGetProducts);
        
        if($getProductDetailResponse['code'] == 201){
            return 'login page';
       }

        return response()->json([
            'status' => true,
            'code' => 200,
            'options' => $getProductDetailResponse['options'] ?? [],
            'additions' => $getProductDetailResponse['additions'] ?? [],
            'message' => 'success'
        ]);
    }

    public function checkout(Request $request){
        $cpi_token = env('NEWPOS_TOKEN');
        $cpi_url = env('CPI_URL');

        $add_to_cart_url = $cpi_url.'store_add_to_cart';

        //$cart_data = $request->cartData;
        $store_id = env('STORE_ID'); 

        $cart = $request->cartData;
        $totalDiscount = $request->totalDiscount;
        $paymentItem = $request->paymentItem;

        $mainItems = collect($cart)->filter(fn($item) => $item['detail'] === 'main')->values();
        $options   = collect($cart)->filter(fn($item) => $item['detail'] === 'op')->values();
        $additions = collect($cart)->filter(fn($item) => $item['detail'] === 'ad')->values();

        // First, attach additions to their respective option parents
        $optionsWithAdditions = $options->map(function ($option) use ($additions) {
            $option['additions'] = $additions->filter(fn($ad) => $ad['parent'] == $option['id'])->values();
            return $option;
        });

        // Then, attach additions to main items, and just keep options as separate entries
        $nestedCart = $mainItems->map(function ($main) use ($additions) {
            $main['additions'] = $additions->filter(fn($ad) => $ad['parent'] == $main['id'])->values();
            return $main;
        })->merge($optionsWithAdditions)->values();

        //$cartDatas =  response()->json($nestedCart);

        //return $nestedCart;


        $addToCartData = ['cart_datas' => $nestedCart, 'store_id' => $store_id];

        //add to cart
        $getAddToCartResponse = Http::withHeaders(['fcmToken' => 'abc123','cpiToken' => $cpi_token,'platform' =>'new_pos', 'Content-Type' => 'application/json','Accept-Language' => 'en'])->post($add_to_cart_url, $addToCartData);
        
        //return $getAddToCartResponse;
        
        if($getAddToCartResponse['code'] == 201){
            return response()->json(['status' => false, 'code' => 201,'message' => 'login']);
        }

        if($getAddToCartResponse['code'] == 200){

            $cart_ids = $getAddToCartResponse['cart_ids'];
            $store_checkout_url = $cpi_url.'store_checkout';
            $storeCheckoutData = ['cart_ids' => $cart_ids, 'store_id' => $store_id, 'totalDiscount' => $totalDiscount];
            //store checkout
            $storeCheckoutResponse = Http::withHeaders(['fcmToken' => 'abc123','cpiToken' => $cpi_token,'platform' =>'new_pos', 'Content-Type' => 'application/json','Accept-Language' => 'en'])->post($store_checkout_url, $storeCheckoutData);
            //return $storeCheckoutResponse; 
            if($storeCheckoutResponse['code'] == 200){

                $pro_qty_arr = $getAddToCartResponse['product_qty_arr'];
                $pro_qty_reduce_url = $cpi_url.'store_checkout_product_quantity_reduce';
                $proQtyData = ['pro_qty_arr' => $pro_qty_arr, 'store_id' => $store_id];
                //reduce product and option quantity
                $getProductQtyReduceResponse = Http::withHeaders(['fcmToken' => 'abc123','cpiToken' => $cpi_token,'platform' =>'new_pos', 'Content-Type' => 'application/json','Accept-Language' => 'en'])->post($pro_qty_reduce_url, $proQtyData);
                if($getProductQtyReduceResponse['code'] == 200){
                    return response()->json(['status' => true, 'code' => 200,'message' => 'success']);
                }
            }
        }

    }
}
